/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition;

import java.util.Map;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnJava;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ConditionContext;
import org.qubership.profiler.shaded.org.springframework.core.annotation.Order;
import org.qubership.profiler.shaded.org.springframework.core.type.AnnotatedTypeMetadata;

@Order(value=-2147483628)
class OnJavaCondition
extends SpringBootCondition {
    private static final ConditionalOnJava.JavaVersion JVM_VERSION = ConditionalOnJava.JavaVersion.getJavaVersion();

    OnJavaCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map<String, Object> attributes = metadata.getAnnotationAttributes(ConditionalOnJava.class.getName());
        ConditionalOnJava.Range range = (ConditionalOnJava.Range)((Object)attributes.get("range"));
        ConditionalOnJava.JavaVersion version = (ConditionalOnJava.JavaVersion)((Object)attributes.get("value"));
        return this.getMatchOutcome(range, JVM_VERSION, version);
    }

    protected ConditionOutcome getMatchOutcome(ConditionalOnJava.Range range, ConditionalOnJava.JavaVersion runningVersion, ConditionalOnJava.JavaVersion version) {
        boolean match = runningVersion.isWithin(range, version);
        String expected = String.format(range == ConditionalOnJava.Range.EQUAL_OR_NEWER ? "(%s or newer)" : "(older than %s)", new Object[]{version});
        ConditionMessage message = ConditionMessage.forCondition(ConditionalOnJava.class, expected).foundExactly((Object)runningVersion);
        return new ConditionOutcome(match, message);
    }
}

