/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition;

import java.util.ArrayList;
import java.util.List;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ConditionContext;
import org.qubership.profiler.shaded.org.springframework.core.annotation.Order;
import org.qubership.profiler.shaded.org.springframework.core.io.DefaultResourceLoader;
import org.qubership.profiler.shaded.org.springframework.core.io.ResourceLoader;
import org.qubership.profiler.shaded.org.springframework.core.type.AnnotatedTypeMetadata;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.MultiValueMap;

@Order(value=-2147483628)
class OnResourceCondition
extends SpringBootCondition {
    private final ResourceLoader defaultResourceLoader = new DefaultResourceLoader();

    OnResourceCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MultiValueMap<String, Object> attributes = metadata.getAllAnnotationAttributes(ConditionalOnResource.class.getName(), true);
        ResourceLoader loader = context.getResourceLoader() == null ? this.defaultResourceLoader : context.getResourceLoader();
        ArrayList<String> locations = new ArrayList<String>();
        this.collectValues(locations, (List)attributes.get("resources"));
        Assert.isTrue(!locations.isEmpty(), "@ConditionalOnResource annotations must specify at least one resource location");
        ArrayList<String> missing = new ArrayList<String>();
        for (String location : locations) {
            String resource = context.getEnvironment().resolvePlaceholders(location);
            if (loader.getResource(resource).exists()) continue;
            missing.add(location);
        }
        if (!missing.isEmpty()) {
            return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnResource.class, new Object[0]).didNotFind("resource", "resources").items(ConditionMessage.Style.QUOTE, missing));
        }
        return ConditionOutcome.match(ConditionMessage.forCondition(ConditionalOnResource.class, new Object[0]).found("location", "locations").items(locations));
    }

    private void collectValues(List<String> names, List<Object> values) {
        for (Object value : values) {
            for (Object item : (Object[])value) {
                names.add((String)item);
            }
        }
    }
}

