/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.couchbase;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseBucket;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.cluster.ClusterInfo;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.couchbase.CouchbaseProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.couchbase.OnBootstrapHostsCondition;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Conditional;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ConfigurationCondition;
import org.qubership.profiler.shaded.org.springframework.context.annotation.DependsOn;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnClass(value={CouchbaseBucket.class, Cluster.class})
@Conditional(value={CouchbaseCondition.class})
@EnableConfigurationProperties(value={CouchbaseProperties.class})
public class CouchbaseAutoConfiguration {

    static class CouchbaseCondition
    extends AnyNestedCondition {
        CouchbaseCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(type={"org.qubership.profiler.shaded.org.springframework.data.couchbase.config.CouchbaseConfigurer"})
        static class CouchbaseConfigurerAvailable {
            CouchbaseConfigurerAvailable() {
            }
        }

        @Conditional(value={OnBootstrapHostsCondition.class})
        static class BootstrapHostsProperty {
            BootstrapHostsProperty() {
            }
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={CouchbaseConfiguration.class}, type={"org.qubership.profiler.shaded.org.springframework.data.couchbase.config.CouchbaseConfigurer"})
    public static class CouchbaseConfiguration {
        private final CouchbaseProperties properties;

        public CouchbaseConfiguration(CouchbaseProperties properties) {
            this.properties = properties;
        }

        @Bean
        @Primary
        public DefaultCouchbaseEnvironment couchbaseEnvironment() throws Exception {
            return this.initializeEnvironmentBuilder(this.properties).build();
        }

        @Bean
        @Primary
        public Cluster couchbaseCluster() throws Exception {
            return CouchbaseCluster.create((CouchbaseEnvironment)this.couchbaseEnvironment(), this.properties.getBootstrapHosts());
        }

        @Bean
        @Primary
        @DependsOn(value={"couchbaseClient"})
        public ClusterInfo couchbaseClusterInfo() throws Exception {
            return this.couchbaseCluster().clusterManager(this.properties.getBucket().getName(), this.properties.getBucket().getPassword()).info();
        }

        @Bean
        @Primary
        public Bucket couchbaseClient() throws Exception {
            return this.couchbaseCluster().openBucket(this.properties.getBucket().getName(), this.properties.getBucket().getPassword());
        }

        protected DefaultCouchbaseEnvironment.Builder initializeEnvironmentBuilder(CouchbaseProperties properties) {
            CouchbaseProperties.Endpoints endpoints = properties.getEnv().getEndpoints();
            CouchbaseProperties.Timeouts timeouts = properties.getEnv().getTimeouts();
            DefaultCouchbaseEnvironment.Builder builder = DefaultCouchbaseEnvironment.builder().connectTimeout(timeouts.getConnect()).kvEndpoints(endpoints.getKeyValue()).kvTimeout(timeouts.getKeyValue()).queryEndpoints(endpoints.getQuery()).queryTimeout(timeouts.getQuery()).viewEndpoints(endpoints.getView()).socketConnectTimeout(timeouts.getSocketConnect()).viewTimeout(timeouts.getView());
            CouchbaseProperties.Ssl ssl = properties.getEnv().getSsl();
            if (ssl.getEnabled().booleanValue()) {
                builder.sslEnabled(true);
                if (ssl.getKeyStore() != null) {
                    builder.sslKeystoreFile(ssl.getKeyStore());
                }
                if (ssl.getKeyStorePassword() != null) {
                    builder.sslKeystorePassword(ssl.getKeyStorePassword());
                }
            }
            return builder;
        }
    }
}

