/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.diagnostics.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qubership.profiler.shaded.org.springframework.beans.BeansException;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactoryAware;
import org.qubership.profiler.shaded.org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.qubership.profiler.shaded.org.springframework.boot.diagnostics.FailureAnalysis;
import org.qubership.profiler.shaded.org.springframework.boot.diagnostics.analyzer.AbstractInjectionFailureAnalyzer;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.core.ResolvableType;
import org.qubership.profiler.shaded.org.springframework.core.type.MethodMetadata;
import org.qubership.profiler.shaded.org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.qubership.profiler.shaded.org.springframework.core.type.classreading.MetadataReader;
import org.qubership.profiler.shaded.org.springframework.core.type.classreading.MetadataReaderFactory;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;

class NoSuchBeanDefinitionFailureAnalyzer
extends AbstractInjectionFailureAnalyzer<NoSuchBeanDefinitionException>
implements BeanFactoryAware {
    private ConfigurableListableBeanFactory beanFactory;
    private MetadataReaderFactory metadataReaderFactory;
    private ConditionEvaluationReport report;

    NoSuchBeanDefinitionFailureAnalyzer() {
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, beanFactory);
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        this.metadataReaderFactory = new CachingMetadataReaderFactory(this.beanFactory.getBeanClassLoader());
        this.report = ConditionEvaluationReport.get(this.beanFactory);
    }

    @Override
    protected FailureAnalysis analyze(Throwable rootFailure, NoSuchBeanDefinitionException cause, String description) {
        if (cause.getNumberOfBeansFound() != 0) {
            return null;
        }
        List<AutoConfigurationResult> autoConfigurationResults = this.getAutoConfigurationResults(cause);
        StringBuilder message = new StringBuilder();
        message.append(String.format("%s required %s that could not be found.%n", description == null ? "A component" : description, this.getBeanDescription(cause)));
        if (!autoConfigurationResults.isEmpty()) {
            for (AutoConfigurationResult provider : autoConfigurationResults) {
                message.append(String.format("\t- %s%n", provider));
            }
        }
        String action = String.format("Consider %s %s in your configuration.", !autoConfigurationResults.isEmpty() ? "revisiting the conditions above or defining" : "defining", this.getBeanDescription(cause));
        return new FailureAnalysis(message.toString(), action, cause);
    }

    private String getBeanDescription(NoSuchBeanDefinitionException cause) {
        if (cause.getResolvableType() != null) {
            Class<?> type = this.extractBeanType(cause.getResolvableType());
            return "a bean of type '" + type.getName() + "'";
        }
        return "a bean named '" + cause.getBeanName() + "'";
    }

    private Class<?> extractBeanType(ResolvableType resolvableType) {
        ResolvableType collectionType = resolvableType.asCollection();
        if (!collectionType.equals(ResolvableType.NONE)) {
            return collectionType.getGeneric(0).getRawClass();
        }
        ResolvableType mapType = resolvableType.asMap();
        if (!mapType.equals(ResolvableType.NONE)) {
            return mapType.getGeneric(1).getRawClass();
        }
        return resolvableType.getRawClass();
    }

    private List<AutoConfigurationResult> getAutoConfigurationResults(NoSuchBeanDefinitionException cause) {
        ArrayList<AutoConfigurationResult> results = new ArrayList<AutoConfigurationResult>();
        this.collectReportedConditionOutcomes(cause, results);
        this.collectExcludedAutoConfiguration(cause, results);
        return results;
    }

    private void collectReportedConditionOutcomes(NoSuchBeanDefinitionException cause, List<AutoConfigurationResult> results) {
        for (Map.Entry<String, ConditionEvaluationReport.ConditionAndOutcomes> entry : this.report.getConditionAndOutcomesBySource().entrySet()) {
            Source source = new Source(entry.getKey());
            ConditionEvaluationReport.ConditionAndOutcomes conditionAndOutcomes = entry.getValue();
            if (conditionAndOutcomes.isFullMatch()) continue;
            BeanMethods methods = new BeanMethods(source, cause);
            for (ConditionEvaluationReport.ConditionAndOutcome conditionAndOutcome : conditionAndOutcomes) {
                if (conditionAndOutcome.getOutcome().isMatch()) continue;
                for (MethodMetadata method : methods) {
                    results.add(new AutoConfigurationResult(method, conditionAndOutcome.getOutcome(), source.isMethod()));
                }
            }
        }
    }

    private void collectExcludedAutoConfiguration(NoSuchBeanDefinitionException cause, List<AutoConfigurationResult> results) {
        for (String excludedClass : this.report.getExclusions()) {
            Source source = new Source(excludedClass);
            BeanMethods methods = new BeanMethods(source, cause);
            for (MethodMetadata method : methods) {
                String message = String.format("auto-configuration '%s' was excluded", ClassUtils.getShortName(excludedClass));
                results.add(new AutoConfigurationResult(method, new ConditionOutcome(false, message), false));
            }
        }
    }

    private class AutoConfigurationResult {
        private final MethodMetadata methodMetadata;
        private final ConditionOutcome conditionOutcome;
        private final boolean methodEvaluated;

        AutoConfigurationResult(MethodMetadata methodMetadata, ConditionOutcome conditionOutcome, boolean methodEvaluated) {
            this.methodMetadata = methodMetadata;
            this.conditionOutcome = conditionOutcome;
            this.methodEvaluated = methodEvaluated;
        }

        public String toString() {
            if (this.methodEvaluated) {
                return String.format("Bean method '%s' in '%s' not loaded because %s", this.methodMetadata.getMethodName(), ClassUtils.getShortName(this.methodMetadata.getDeclaringClassName()), this.conditionOutcome.getMessage());
            }
            return String.format("Bean method '%s' not loaded because %s", this.methodMetadata.getMethodName(), this.conditionOutcome.getMessage());
        }
    }

    private class BeanMethods
    implements Iterable<MethodMetadata> {
        private final List<MethodMetadata> methods;

        BeanMethods(Source source, NoSuchBeanDefinitionException cause) {
            this.methods = this.findBeanMethods(source, cause);
        }

        private List<MethodMetadata> findBeanMethods(Source source, NoSuchBeanDefinitionException cause) {
            try {
                MetadataReader classMetadata = NoSuchBeanDefinitionFailureAnalyzer.this.metadataReaderFactory.getMetadataReader(source.getClassName());
                Set<MethodMetadata> candidates = classMetadata.getAnnotationMetadata().getAnnotatedMethods(Bean.class.getName());
                ArrayList<MethodMetadata> result = new ArrayList<MethodMetadata>();
                for (MethodMetadata candidate : candidates) {
                    if (!this.isMatch(candidate, source, cause)) continue;
                    result.add(candidate);
                }
                return Collections.unmodifiableList(result);
            }
            catch (Exception ex) {
                return Collections.emptyList();
            }
        }

        private boolean isMatch(MethodMetadata candidate, Source source, NoSuchBeanDefinitionException cause) {
            if (source.getMethodName() != null && !source.getMethodName().equals(candidate.getMethodName())) {
                return false;
            }
            String name = cause.getBeanName();
            ResolvableType resolvableType = cause.getResolvableType();
            return name != null && this.hasName(candidate, name) || resolvableType != null && this.hasType(candidate, NoSuchBeanDefinitionFailureAnalyzer.this.extractBeanType(resolvableType));
        }

        private boolean hasName(MethodMetadata methodMetadata, String name) {
            String[] candidates;
            Map<String, Object> attributes = methodMetadata.getAnnotationAttributes(Bean.class.getName());
            String[] stringArray = candidates = attributes == null ? null : (String[])attributes.get("name");
            if (candidates != null) {
                for (String candidate : candidates) {
                    if (!candidate.equals(name)) continue;
                    return true;
                }
                return false;
            }
            return methodMetadata.getMethodName().equals(name);
        }

        private boolean hasType(MethodMetadata candidate, Class<?> type) {
            String returnTypeName = candidate.getReturnTypeName();
            if (type.getName().equals(returnTypeName)) {
                return true;
            }
            try {
                Class<?> returnType = ClassUtils.forName(returnTypeName, NoSuchBeanDefinitionFailureAnalyzer.this.beanFactory.getBeanClassLoader());
                return type.isAssignableFrom(returnType);
            }
            catch (Throwable ex) {
                return false;
            }
        }

        @Override
        public Iterator<MethodMetadata> iterator() {
            return this.methods.iterator();
        }
    }

    private class Source {
        private final String className;
        private final String methodName;

        Source(String source) {
            String[] tokens = source.split("#");
            this.className = tokens.length > 1 ? tokens[0] : source;
            this.methodName = tokens.length == 2 ? tokens[1] : null;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public boolean isMethod() {
            return this.methodName != null;
        }
    }
}

