/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.BeanDefinition;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.qubership.profiler.shaded.org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.qubership.profiler.shaded.org.springframework.beans.factory.support.GenericBeanDefinition;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.domain.EntityScan;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.qubership.profiler.shaded.org.springframework.core.annotation.AnnotationAttributes;
import org.qubership.profiler.shaded.org.springframework.core.annotation.Order;
import org.qubership.profiler.shaded.org.springframework.core.type.AnnotationMetadata;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;

public class EntityScanPackages {
    private static final String BEAN = EntityScanPackages.class.getName();
    private static final EntityScanPackages NONE = new EntityScanPackages(new String[0]);
    private final List<String> packageNames;

    EntityScanPackages(String ... packageNames) {
        ArrayList<String> packages = new ArrayList<String>();
        for (String name : packageNames) {
            if (!StringUtils.hasText(name)) continue;
            packages.add(name);
        }
        this.packageNames = Collections.unmodifiableList(packages);
    }

    public List<String> getPackageNames() {
        return this.packageNames;
    }

    public static EntityScanPackages get(BeanFactory beanFactory) {
        try {
            return beanFactory.getBean(BEAN, EntityScanPackages.class);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return NONE;
        }
    }

    public static void register(BeanDefinitionRegistry registry, String ... packageNames) {
        Assert.notNull(registry, "Registry must not be null");
        Assert.notNull(packageNames, "PackageNames must not be null");
        EntityScanPackages.register(registry, Arrays.asList(packageNames));
    }

    public static void register(BeanDefinitionRegistry registry, Collection<String> packageNames) {
        Assert.notNull(registry, "Registry must not be null");
        Assert.notNull(packageNames, "PackageNames must not be null");
        if (registry.containsBeanDefinition(BEAN)) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(BEAN);
            ConstructorArgumentValues constructorArguments = beanDefinition.getConstructorArgumentValues();
            constructorArguments.addIndexedArgumentValue(0, EntityScanPackages.addPackageNames(constructorArguments, packageNames));
        } else {
            GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
            beanDefinition.setBeanClass(EntityScanPackages.class);
            beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, packageNames.toArray(new String[packageNames.size()]));
            beanDefinition.setRole(2);
            registry.registerBeanDefinition(BEAN, beanDefinition);
        }
    }

    private static String[] addPackageNames(ConstructorArgumentValues constructorArguments, Collection<String> packageNames) {
        String[] existing = (String[])constructorArguments.getIndexedArgumentValue(0, String[].class).getValue();
        LinkedHashSet<String> merged = new LinkedHashSet<String>();
        merged.addAll(Arrays.asList(existing));
        merged.addAll(packageNames);
        return merged.toArray(new String[merged.size()]);
    }

    @Order(value=-2147483648)
    static class Registrar
    implements ImportBeanDefinitionRegistrar {
        Registrar() {
        }

        @Override
        public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
            EntityScanPackages.register(registry, this.getPackagesToScan(metadata));
        }

        private Set<String> getPackagesToScan(AnnotationMetadata metadata) {
            AnnotationAttributes attributes = AnnotationAttributes.fromMap(metadata.getAnnotationAttributes(EntityScan.class.getName()));
            String[] basePackages = attributes.getStringArray("basePackages");
            Class<?>[] basePackageClasses = attributes.getClassArray("basePackageClasses");
            LinkedHashSet<String> packagesToScan = new LinkedHashSet<String>();
            packagesToScan.addAll(Arrays.asList(basePackages));
            for (Class<?> basePackageClass : basePackageClasses) {
                packagesToScan.add(ClassUtils.getPackageName(basePackageClass));
            }
            if (packagesToScan.isEmpty()) {
                String packageName = ClassUtils.getPackageName(metadata.getClassName());
                Assert.state(!StringUtils.isEmpty(packageName), "@EntityScan cannot be used with the default package");
                return Collections.singleton(packageName);
            }
            return packagesToScan;
        }
    }
}

