/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc;

import javax.sql.DataSource;
import org.qubership.profiler.shaded.org.springframework.beans.factory.ObjectProvider;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.jdbc.core.JdbcTemplate;
import org.qubership.profiler.shaded.org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.qubership.profiler.shaded.org.springframework.transaction.PlatformTransactionManager;
import org.qubership.profiler.shaded.org.springframework.transaction.annotation.AbstractTransactionManagementConfiguration;
import org.qubership.profiler.shaded.org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@ConditionalOnClass(value={JdbcTemplate.class, PlatformTransactionManager.class})
@AutoConfigureOrder(value=0x7FFFFFFF)
@EnableConfigurationProperties(value={DataSourceProperties.class})
public class DataSourceTransactionManagerAutoConfiguration {

    @ConditionalOnMissingBean(value={AbstractTransactionManagementConfiguration.class})
    @Configuration
    @EnableTransactionManagement(proxyTargetClass=true)
    protected static class TransactionManagementConfiguration {
        protected TransactionManagementConfiguration() {
        }
    }

    @Configuration
    @ConditionalOnSingleCandidate(value=DataSource.class)
    static class DataSourceTransactionManagerConfiguration {
        private final DataSource dataSource;
        private final TransactionManagerCustomizers transactionManagerCustomizers;

        DataSourceTransactionManagerConfiguration(DataSource dataSource, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
            this.dataSource = dataSource;
            this.transactionManagerCustomizers = transactionManagerCustomizers.getIfAvailable();
        }

        @Bean
        @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
        public DataSourceTransactionManager transactionManager(DataSourceProperties properties) {
            DataSourceTransactionManager transactionManager = new DataSourceTransactionManager(this.dataSource);
            if (this.transactionManagerCustomizers != null) {
                this.transactionManagerCustomizers.customize((PlatformTransactionManager)transactionManager);
            }
            return transactionManager;
        }
    }
}

