/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc;

import javax.sql.DataSource;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Primary;
import org.qubership.profiler.shaded.org.springframework.jdbc.core.JdbcOperations;
import org.qubership.profiler.shaded.org.springframework.jdbc.core.JdbcTemplate;
import org.qubership.profiler.shaded.org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.qubership.profiler.shaded.org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

@Configuration
@ConditionalOnClass(value={DataSource.class, JdbcTemplate.class})
@ConditionalOnSingleCandidate(value=DataSource.class)
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class JdbcTemplateAutoConfiguration {
    private final DataSource dataSource;

    public JdbcTemplateAutoConfiguration(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={JdbcOperations.class})
    public JdbcTemplate jdbcTemplate() {
        return new JdbcTemplate(this.dataSource);
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={NamedParameterJdbcOperations.class})
    public NamedParameterJdbcTemplate namedParameterJdbcTemplate() {
        return new NamedParameterJdbcTemplate(this.dataSource);
    }
}

