/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jms;

import javax.jms.ConnectionFactory;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.qubership.profiler.shaded.org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.qubership.profiler.shaded.org.springframework.jms.support.converter.MessageConverter;
import org.qubership.profiler.shaded.org.springframework.jms.support.destination.DestinationResolver;
import org.qubership.profiler.shaded.org.springframework.transaction.PlatformTransactionManager;
import org.qubership.profiler.shaded.org.springframework.transaction.jta.JtaTransactionManager;
import org.qubership.profiler.shaded.org.springframework.util.Assert;

public final class DefaultJmsListenerContainerFactoryConfigurer {
    private DestinationResolver destinationResolver;
    private MessageConverter messageConverter;
    private JtaTransactionManager transactionManager;
    private JmsProperties jmsProperties;

    void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    void setTransactionManager(JtaTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    void setJmsProperties(JmsProperties jmsProperties) {
        this.jmsProperties = jmsProperties;
    }

    public void configure(DefaultJmsListenerContainerFactory factory, ConnectionFactory connectionFactory) {
        String concurrency;
        Assert.notNull(factory, "Factory must not be null");
        Assert.notNull(connectionFactory, "ConnectionFactory must not be null");
        factory.setConnectionFactory(connectionFactory);
        factory.setPubSubDomain(Boolean.valueOf(this.jmsProperties.isPubSubDomain()));
        if (this.transactionManager != null) {
            factory.setTransactionManager((PlatformTransactionManager)this.transactionManager);
        } else {
            factory.setSessionTransacted(Boolean.valueOf(true));
        }
        if (this.destinationResolver != null) {
            factory.setDestinationResolver(this.destinationResolver);
        }
        if (this.messageConverter != null) {
            factory.setMessageConverter(this.messageConverter);
        }
        JmsProperties.Listener listener = this.jmsProperties.getListener();
        factory.setAutoStartup(listener.isAutoStartup());
        if (listener.getAcknowledgeMode() != null) {
            factory.setSessionAcknowledgeMode(Integer.valueOf(listener.getAcknowledgeMode().getMode()));
        }
        if ((concurrency = listener.formatConcurrency()) != null) {
            factory.setConcurrency(concurrency);
        }
    }
}

