/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jms;

import javax.jms.ConnectionFactory;
import javax.jms.Message;
import org.qubership.profiler.shaded.org.springframework.beans.factory.ObjectProvider;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jms.JmsAnnotationDrivenConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Import;
import org.qubership.profiler.shaded.org.springframework.jms.core.JmsMessagingTemplate;
import org.qubership.profiler.shaded.org.springframework.jms.core.JmsTemplate;
import org.qubership.profiler.shaded.org.springframework.jms.support.converter.MessageConverter;
import org.qubership.profiler.shaded.org.springframework.jms.support.destination.DestinationResolver;

@Configuration
@ConditionalOnClass(value={Message.class, JmsTemplate.class})
@ConditionalOnBean(value={ConnectionFactory.class})
@EnableConfigurationProperties(value={JmsProperties.class})
@Import(value={JmsAnnotationDrivenConfiguration.class})
public class JmsAutoConfiguration {

    @ConditionalOnClass(value={JmsMessagingTemplate.class})
    @Import(value={JmsTemplateConfiguration.class})
    protected static class MessagingTemplateConfiguration {
        protected MessagingTemplateConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnSingleCandidate(value=JmsTemplate.class)
        public JmsMessagingTemplate jmsMessagingTemplate(JmsTemplate jmsTemplate) {
            return new JmsMessagingTemplate(jmsTemplate);
        }
    }

    @Configuration
    protected static class JmsTemplateConfiguration {
        private final JmsProperties properties;
        private final ObjectProvider<DestinationResolver> destinationResolver;
        private final ObjectProvider<MessageConverter> messageConverter;

        public JmsTemplateConfiguration(JmsProperties properties, ObjectProvider<DestinationResolver> destinationResolver, ObjectProvider<MessageConverter> messageConverter) {
            this.properties = properties;
            this.destinationResolver = destinationResolver;
            this.messageConverter = messageConverter;
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnSingleCandidate(value=ConnectionFactory.class)
        public JmsTemplate jmsTemplate(ConnectionFactory connectionFactory) {
            JmsProperties.Template template;
            MessageConverter messageConverter;
            JmsTemplate jmsTemplate = new JmsTemplate(connectionFactory);
            jmsTemplate.setPubSubDomain(this.properties.isPubSubDomain());
            DestinationResolver destinationResolver = this.destinationResolver.getIfUnique();
            if (destinationResolver != null) {
                jmsTemplate.setDestinationResolver(destinationResolver);
            }
            if ((messageConverter = this.messageConverter.getIfUnique()) != null) {
                jmsTemplate.setMessageConverter(messageConverter);
            }
            if ((template = this.properties.getTemplate()).getDefaultDestination() != null) {
                jmsTemplate.setDefaultDestinationName(template.getDefaultDestination());
            }
            if (template.getDeliveryDelay() != null) {
                jmsTemplate.setDeliveryDelay(template.getDeliveryDelay().longValue());
            }
            jmsTemplate.setExplicitQosEnabled(template.determineQosEnabled());
            if (template.getDeliveryMode() != null) {
                jmsTemplate.setDeliveryMode(template.getDeliveryMode().getValue());
            }
            if (template.getPriority() != null) {
                jmsTemplate.setPriority(template.getPriority().intValue());
            }
            if (template.getTimeToLive() != null) {
                jmsTemplate.setTimeToLive(template.getTimeToLive().longValue());
            }
            if (template.getReceiveTimeout() != null) {
                jmsTemplate.setReceiveTimeout(template.getReceiveTimeout().longValue());
            }
            return jmsTemplate;
        }
    }
}

