/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jms.artemis;

import javax.jms.ConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.transaction.TransactionManager;
import org.qubership.profiler.shaded.org.apache.activemq.artemis.jms.client.ActiveMQXAConnectionFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.ListableBeanFactory;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jms.artemis.ArtemisConnectionFactoryFactory;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jms.artemis.ArtemisProperties;
import org.qubership.profiler.shaded.org.springframework.boot.jta.XAConnectionFactoryWrapper;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnMissingBean(value={ConnectionFactory.class})
@ConditionalOnClass(value={TransactionManager.class})
@ConditionalOnBean(value={XAConnectionFactoryWrapper.class})
class ArtemisXAConnectionFactoryConfiguration {
    ArtemisXAConnectionFactoryConfiguration() {
    }

    @Primary
    @Bean(name={"jmsConnectionFactory", "xaJmsConnectionFactory"})
    public ConnectionFactory jmsConnectionFactory(ListableBeanFactory beanFactory, ArtemisProperties properties, XAConnectionFactoryWrapper wrapper) throws Exception {
        return wrapper.wrapConnectionFactory((XAConnectionFactory)new ArtemisConnectionFactoryFactory(beanFactory, properties).createConnectionFactory(ActiveMQXAConnectionFactory.class));
    }

    @Bean
    public ActiveMQXAConnectionFactory nonXaJmsConnectionFactory(ListableBeanFactory beanFactory, ArtemisProperties properties) {
        return new ArtemisConnectionFactoryFactory(beanFactory, properties).createConnectionFactory(ActiveMQXAConnectionFactory.class);
    }
}

