/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jmx;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.qubership.profiler.shaded.org.springframework.beans.BeansException;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContext;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContextAware;
import org.qubership.profiler.shaded.org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.qubership.profiler.shaded.org.springframework.jmx.export.naming.MetadataNamingStrategy;
import org.qubership.profiler.shaded.org.springframework.jmx.support.ObjectNameManager;
import org.qubership.profiler.shaded.org.springframework.util.ObjectUtils;

public class ParentAwareNamingStrategy
extends MetadataNamingStrategy
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private boolean ensureUniqueRuntimeObjectNames;

    public ParentAwareNamingStrategy(JmxAttributeSource attributeSource) {
        super(attributeSource);
    }

    public void setEnsureUniqueRuntimeObjectNames(boolean ensureUniqueRuntimeObjectNames) {
        this.ensureUniqueRuntimeObjectNames = ensureUniqueRuntimeObjectNames;
    }

    @Override
    public ObjectName getObjectName(Object managedBean, String beanKey) throws MalformedObjectNameException {
        ObjectName name = super.getObjectName(managedBean, beanKey);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.putAll(name.getKeyPropertyList());
        if (this.ensureUniqueRuntimeObjectNames) {
            properties.put("identity", ObjectUtils.getIdentityHexString(managedBean));
        } else if (this.parentContextContainsSameBean(this.applicationContext, beanKey)) {
            properties.put("context", ObjectUtils.getIdentityHexString(this.applicationContext));
        }
        return ObjectNameManager.getInstance(name.getDomain(), properties);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private boolean parentContextContainsSameBean(ApplicationContext context, String beanKey) {
        if (context.getParent() == null) {
            return false;
        }
        try {
            this.applicationContext.getParent().getBean(beanKey);
            return true;
        }
        catch (BeansException ex) {
            return this.parentContextContainsSameBean(context.getParent(), beanKey);
        }
    }
}

