/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.mobile;

import java.util.List;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.core.annotation.Order;
import org.qubership.profiler.shaded.org.springframework.mobile.device.DeviceHandlerMethodArgumentResolver;
import org.qubership.profiler.shaded.org.springframework.mobile.device.DeviceResolverHandlerInterceptor;
import org.qubership.profiler.shaded.org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.qubership.profiler.shaded.org.springframework.web.servlet.HandlerInterceptor;
import org.qubership.profiler.shaded.org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.qubership.profiler.shaded.org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnClass(value={DeviceResolverHandlerInterceptor.class, DeviceHandlerMethodArgumentResolver.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@ConditionalOnWebApplication
public class DeviceResolverAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={DeviceResolverHandlerInterceptor.class})
    public DeviceResolverHandlerInterceptor deviceResolverHandlerInterceptor() {
        return new DeviceResolverHandlerInterceptor();
    }

    @Bean
    public DeviceHandlerMethodArgumentResolver deviceHandlerMethodArgumentResolver() {
        return new DeviceHandlerMethodArgumentResolver();
    }

    @Configuration
    @Order(value=0)
    protected static class DeviceResolverMvcConfiguration
    extends WebMvcConfigurerAdapter {
        private DeviceResolverHandlerInterceptor deviceResolverHandlerInterceptor;
        private DeviceHandlerMethodArgumentResolver deviceHandlerMethodArgumentResolver;

        protected DeviceResolverMvcConfiguration(DeviceResolverHandlerInterceptor deviceResolverHandlerInterceptor, DeviceHandlerMethodArgumentResolver deviceHandlerMethodArgumentResolver) {
            this.deviceResolverHandlerInterceptor = deviceResolverHandlerInterceptor;
            this.deviceHandlerMethodArgumentResolver = deviceHandlerMethodArgumentResolver;
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)this.deviceResolverHandlerInterceptor);
        }

        public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            argumentResolvers.add((HandlerMethodArgumentResolver)this.deviceHandlerMethodArgumentResolver);
        }
    }
}

