/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.oauth2.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.oauth2.resource.AuthoritiesExtractor;
import org.qubership.profiler.shaded.org.springframework.security.core.GrantedAuthority;
import org.qubership.profiler.shaded.org.springframework.security.core.authority.AuthorityUtils;
import org.qubership.profiler.shaded.org.springframework.util.ObjectUtils;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;

public class FixedAuthoritiesExtractor
implements AuthoritiesExtractor {
    private static final String AUTHORITIES = "authorities";
    private static final String[] AUTHORITY_KEYS = new String[]{"authority", "role", "value"};

    @Override
    public List<GrantedAuthority> extractAuthorities(Map<String, Object> map) {
        String authorities = "ROLE_USER";
        if (map.containsKey(AUTHORITIES)) {
            authorities = this.asAuthorities(map.get(AUTHORITIES));
        }
        return AuthorityUtils.commaSeparatedStringToAuthorityList((String)authorities);
    }

    private String asAuthorities(Object object) {
        ArrayList<Object> authorities = new ArrayList<Object>();
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            object = collection.toArray(new Object[0]);
        }
        if (ObjectUtils.isArray(object)) {
            Object[] array;
            for (Object value : array = (Object[])object) {
                if (value instanceof String) {
                    authorities.add(value);
                    continue;
                }
                if (value instanceof Map) {
                    authorities.add(this.asAuthority((Map)value));
                    continue;
                }
                authorities.add(value);
            }
            return StringUtils.collectionToCommaDelimitedString(authorities);
        }
        return object.toString();
    }

    private Object asAuthority(Map<?, ?> map) {
        if (map.size() == 1) {
            return map.values().iterator().next();
        }
        for (String key : AUTHORITY_KEYS) {
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        return map;
    }
}

