/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.qubership.profiler.shaded.org.apache.commons.logging.Log;
import org.qubership.profiler.shaded.org.apache.commons.logging.LogFactory;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.transaction.PlatformTransactionManagerCustomizer;
import org.qubership.profiler.shaded.org.springframework.core.ResolvableType;
import org.qubership.profiler.shaded.org.springframework.transaction.PlatformTransactionManager;

public class TransactionManagerCustomizers {
    private static final Log logger = LogFactory.getLog(TransactionManagerCustomizers.class);
    private final List<PlatformTransactionManagerCustomizer<?>> customizers;

    public TransactionManagerCustomizers(Collection<? extends PlatformTransactionManagerCustomizer<?>> customizers) {
        this.customizers = customizers == null ? null : new ArrayList(customizers);
    }

    public void customize(PlatformTransactionManager transactionManager) {
        if (this.customizers != null) {
            for (PlatformTransactionManagerCustomizer<?> customizer : this.customizers) {
                Class<?> generic = ResolvableType.forClass(PlatformTransactionManagerCustomizer.class, customizer.getClass()).resolveGeneric(new int[0]);
                if (!generic.isInstance(transactionManager)) continue;
                this.customize(transactionManager, customizer);
            }
        }
    }

    private void customize(PlatformTransactionManager transactionManager, PlatformTransactionManagerCustomizer customizer) {
        block2: {
            try {
                customizer.customize(transactionManager);
            }
            catch (ClassCastException ex) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Non-matching transaction manager type for customizer: " + customizer, ex);
            }
        }
    }
}

