/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web;

import io.undertow.Undertow;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.qubership.profiler.shaded.org.apache.catalina.startup.Tomcat;
import org.qubership.profiler.shaded.org.springframework.beans.BeansException;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactoryAware;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.qubership.profiler.shaded.org.springframework.beans.factory.support.RootBeanDefinition;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizerBeanPostProcessor;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainerFactory;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.undertow.UndertowEmbeddedServletContainerFactory;
import org.qubership.profiler.shaded.org.springframework.boot.web.servlet.ErrorPageRegistrarBeanPostProcessor;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Import;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.qubership.profiler.shaded.org.springframework.core.type.AnnotationMetadata;
import org.qubership.profiler.shaded.org.springframework.util.ObjectUtils;
import org.xnio.SslClientAuthMode;

@AutoConfigureOrder(value=-2147483648)
@Configuration
@ConditionalOnWebApplication
@Import(value={BeanPostProcessorsRegistrar.class})
public class EmbeddedServletContainerAutoConfiguration {

    public static class BeanPostProcessorsRegistrar
    implements ImportBeanDefinitionRegistrar,
    BeanFactoryAware {
        private ConfigurableListableBeanFactory beanFactory;

        @Override
        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            if (beanFactory instanceof ConfigurableListableBeanFactory) {
                this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
            }
        }

        @Override
        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (this.beanFactory == null) {
                return;
            }
            if (ObjectUtils.isEmpty(this.beanFactory.getBeanNamesForType(EmbeddedServletContainerCustomizerBeanPostProcessor.class, true, false))) {
                registry.registerBeanDefinition("embeddedServletContainerCustomizerBeanPostProcessor", new RootBeanDefinition(EmbeddedServletContainerCustomizerBeanPostProcessor.class));
            }
            if (ObjectUtils.isEmpty(this.beanFactory.getBeanNamesForType(ErrorPageRegistrarBeanPostProcessor.class, true, false))) {
                registry.registerBeanDefinition("errorPageRegistrarBeanPostProcessor", new RootBeanDefinition(ErrorPageRegistrarBeanPostProcessor.class));
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, Undertow.class, SslClientAuthMode.class})
    @ConditionalOnMissingBean(value={EmbeddedServletContainerFactory.class}, search=SearchStrategy.CURRENT)
    public static class EmbeddedUndertow {
        @Bean
        public UndertowEmbeddedServletContainerFactory undertowEmbeddedServletContainerFactory() {
            return new UndertowEmbeddedServletContainerFactory();
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, Server.class, Loader.class, WebAppContext.class})
    @ConditionalOnMissingBean(value={EmbeddedServletContainerFactory.class}, search=SearchStrategy.CURRENT)
    public static class EmbeddedJetty {
        @Bean
        public JettyEmbeddedServletContainerFactory jettyEmbeddedServletContainerFactory() {
            return new JettyEmbeddedServletContainerFactory();
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, Tomcat.class})
    @ConditionalOnMissingBean(value={EmbeddedServletContainerFactory.class}, search=SearchStrategy.CURRENT)
    public static class EmbeddedTomcat {
        @Bean
        public TomcatEmbeddedServletContainerFactory tomcatEmbeddedServletContainerFactory() {
            return new TomcatEmbeddedServletContainerFactory();
        }
    }
}

