/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.webservices;

import java.util.Map;
import javax.servlet.Servlet;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.webservices.WebServicesProperties;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContext;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.ws.config.annotation.EnableWs;
import org.qubership.profiler.shaded.org.springframework.ws.config.annotation.WsConfigurationSupport;
import org.qubership.profiler.shaded.org.springframework.ws.transport.http.MessageDispatcherServlet;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={MessageDispatcherServlet.class})
@ConditionalOnMissingBean(value={WsConfigurationSupport.class})
@EnableConfigurationProperties(value={WebServicesProperties.class})
@AutoConfigureAfter(value={EmbeddedServletContainerAutoConfiguration.class})
public class WebServicesAutoConfiguration {
    private final WebServicesProperties properties;

    public WebServicesAutoConfiguration(WebServicesProperties properties) {
        this.properties = properties;
    }

    @Bean
    public ServletRegistrationBean messageDispatcherServlet(ApplicationContext applicationContext) {
        MessageDispatcherServlet servlet = new MessageDispatcherServlet();
        servlet.setApplicationContext(applicationContext);
        String path = this.properties.getPath();
        String urlMapping = path.endsWith("/") ? path + "*" : path + "/*";
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)servlet, urlMapping);
        WebServicesProperties.Servlet servletProperties = this.properties.getServlet();
        registration.setLoadOnStartup(servletProperties.getLoadOnStartup());
        for (Map.Entry<String, String> entry : servletProperties.getInit().entrySet()) {
            registration.addInitParameter(entry.getKey(), entry.getValue());
        }
        return registration;
    }

    @Configuration
    @EnableWs
    protected static class WsConfiguration {
        protected WsConfiguration() {
        }
    }
}

