/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.websocket;

import java.util.List;
import org.qubership.profiler.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.qubership.profiler.shaded.org.springframework.messaging.converter.ContentTypeResolver;
import org.qubership.profiler.shaded.org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.qubership.profiler.shaded.org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.qubership.profiler.shaded.org.springframework.messaging.converter.MessageConverter;
import org.qubership.profiler.shaded.org.springframework.messaging.converter.StringMessageConverter;
import org.qubership.profiler.shaded.org.springframework.messaging.simp.config.AbstractMessageBrokerConfiguration;
import org.qubership.profiler.shaded.org.springframework.util.MimeTypeUtils;
import org.qubership.profiler.shaded.org.springframework.web.socket.config.annotation.AbstractWebSocketMessageBrokerConfigurer;
import org.qubership.profiler.shaded.org.springframework.web.socket.config.annotation.DelegatingWebSocketMessageBrokerConfiguration;
import org.qubership.profiler.shaded.org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.qubership.profiler.shaded.org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

@ConditionalOnWebApplication
@ConditionalOnClass(value={WebSocketMessageBrokerConfigurer.class})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class})
public class WebSocketMessagingAutoConfiguration {

    @Configuration
    @ConditionalOnBean(value={DelegatingWebSocketMessageBrokerConfiguration.class, ObjectMapper.class})
    @ConditionalOnClass(value={ObjectMapper.class, AbstractMessageBrokerConfiguration.class})
    static class WebSocketMessageConverterConfiguration
    extends AbstractWebSocketMessageBrokerConfigurer {
        private final ObjectMapper objectMapper;

        WebSocketMessageConverterConfiguration(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        public void registerStompEndpoints(StompEndpointRegistry registry) {
        }

        public boolean configureMessageConverters(List<MessageConverter> messageConverters) {
            MappingJackson2MessageConverter converter = new MappingJackson2MessageConverter();
            converter.setObjectMapper(this.objectMapper);
            DefaultContentTypeResolver resolver = new DefaultContentTypeResolver();
            resolver.setDefaultMimeType(MimeTypeUtils.APPLICATION_JSON);
            converter.setContentTypeResolver((ContentTypeResolver)resolver);
            messageConverters.add((MessageConverter)new StringMessageConverter());
            messageConverters.add((MessageConverter)new ByteArrayMessageConverter());
            messageConverters.add((MessageConverter)converter);
            return false;
        }
    }
}

