/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.cloud;

import org.qubership.profiler.shaded.org.springframework.core.env.Environment;

public enum CloudPlatform {
    CLOUD_FOUNDRY{

        @Override
        public boolean isActive(Environment environment) {
            return environment.containsProperty("VCAP_APPLICATION") || environment.containsProperty("VCAP_SERVICES");
        }
    }
    ,
    HEROKU{

        @Override
        public boolean isActive(Environment environment) {
            return environment.containsProperty("DYNO");
        }
    };


    public abstract boolean isActive(Environment var1);

    public boolean isUsingForwardHeaders() {
        return true;
    }

    public static CloudPlatform getActive(Environment environment) {
        if (environment != null) {
            for (CloudPlatform cloudPlatform : CloudPlatform.values()) {
                if (!cloudPlatform.isActive(environment)) continue;
                return cloudPlatform;
            }
        }
        return null;
    }
}

