/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.context.embedded;

import java.util.HashMap;
import java.util.Map;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContext;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContextInitializer;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationListener;
import org.qubership.profiler.shaded.org.springframework.context.ConfigurableApplicationContext;
import org.qubership.profiler.shaded.org.springframework.core.env.ConfigurableEnvironment;
import org.qubership.profiler.shaded.org.springframework.core.env.MapPropertySource;
import org.qubership.profiler.shaded.org.springframework.core.env.MutablePropertySources;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;

public class ServerPortInfoApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    @Override
    public void initialize(ConfigurableApplicationContext applicationContext) {
        applicationContext.addApplicationListener(new ApplicationListener<EmbeddedServletContainerInitializedEvent>(){

            @Override
            public void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
                ServerPortInfoApplicationContextInitializer.this.onApplicationEvent(event);
            }
        });
    }

    protected void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
        String propertyName = this.getPropertyName(event.getApplicationContext());
        this.setPortProperty((ApplicationContext)((Object)event.getApplicationContext()), propertyName, event.getEmbeddedServletContainer().getPort());
    }

    protected String getPropertyName(EmbeddedWebApplicationContext context) {
        String name = context.getNamespace();
        if (StringUtils.isEmpty(name)) {
            name = "server";
        }
        return "local." + name + ".port";
    }

    private void setPortProperty(ApplicationContext context, String propertyName, int port) {
        if (context instanceof ConfigurableApplicationContext) {
            this.setPortProperty(((ConfigurableApplicationContext)context).getEnvironment(), propertyName, port);
        }
        if (context.getParent() != null) {
            this.setPortProperty(context.getParent(), propertyName, port);
        }
    }

    private void setPortProperty(ConfigurableEnvironment environment, String propertyName, int port) {
        MutablePropertySources sources = environment.getPropertySources();
        MapPropertySource source = sources.get("server.ports");
        if (source == null) {
            source = new MapPropertySource("server.ports", (Map<String, Object>)new HashMap<String, Object>());
            sources.addFirst(source);
        }
        ((Map)source.getSource()).put(propertyName, port);
    }
}

