/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.context.embedded.tomcat;

import java.lang.reflect.Method;
import java.util.Set;
import javax.servlet.ServletContext;
import org.qubership.profiler.shaded.org.apache.tomcat.JarScanFilter;
import org.qubership.profiler.shaded.org.apache.tomcat.JarScanner;
import org.qubership.profiler.shaded.org.apache.tomcat.JarScannerCallback;
import org.qubership.profiler.shaded.org.apache.tomcat.util.scan.StandardJarScanFilter;
import org.qubership.profiler.shaded.org.apache.tomcat.util.scan.StandardJarScanner;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedContext;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;
import org.qubership.profiler.shaded.org.springframework.util.ReflectionUtils;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;

class SkipPatternJarScanner
extends StandardJarScanner {
    private static final String JAR_SCAN_FILTER_CLASS = "org.qubership.profiler.shaded.org.apache.tomcat.JarScanFilter";
    private final JarScanner jarScanner;
    private final Set<String> patterns;

    SkipPatternJarScanner(JarScanner jarScanner, Set<String> patterns) {
        Assert.notNull(jarScanner, "JarScanner must not be null");
        Assert.notNull(jarScanner, "Patterns must not be null");
        this.jarScanner = jarScanner;
        this.patterns = patterns;
        this.setPatternToTomcat8SkipFilter();
    }

    private void setPatternToTomcat8SkipFilter() {
        if (ClassUtils.isPresent(JAR_SCAN_FILTER_CLASS, null)) {
            new Tomcat8TldSkipSetter(this).setSkipPattern(this.patterns);
        }
    }

    public void scan(ServletContext context, ClassLoader classloader, JarScannerCallback callback, Set<String> jarsToSkip) {
        Method scanMethod = ReflectionUtils.findMethod(this.jarScanner.getClass(), "scan", ServletContext.class, ClassLoader.class, JarScannerCallback.class, Set.class);
        Assert.notNull(scanMethod, "Unable to find scan method");
        try {
            scanMethod.invoke((Object)this.jarScanner, context, classloader, callback, jarsToSkip == null ? this.patterns : jarsToSkip);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Tomcat 7 reflection failed", ex);
        }
    }

    static void apply(TomcatEmbeddedContext context, Set<String> patterns) {
        SkipPatternJarScanner scanner = new SkipPatternJarScanner(context.getJarScanner(), patterns);
        context.setJarScanner((JarScanner)scanner);
    }

    private static class Tomcat8TldSkipSetter {
        private final StandardJarScanner jarScanner;

        Tomcat8TldSkipSetter(StandardJarScanner jarScanner) {
            this.jarScanner = jarScanner;
        }

        public void setSkipPattern(Set<String> patterns) {
            StandardJarScanFilter filter = new StandardJarScanFilter();
            filter.setTldSkip(StringUtils.collectionToCommaDelimitedString(patterns));
            this.jarScanner.setJarScanFilter((JarScanFilter)filter);
        }
    }
}

