/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.context.event;

import org.qubership.profiler.shaded.org.apache.commons.logging.Log;
import org.qubership.profiler.shaded.org.apache.commons.logging.LogFactory;
import org.qubership.profiler.shaded.org.springframework.boot.SpringApplication;
import org.qubership.profiler.shaded.org.springframework.boot.SpringApplicationRunListener;
import org.qubership.profiler.shaded.org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.qubership.profiler.shaded.org.springframework.boot.context.event.ApplicationFailedEvent;
import org.qubership.profiler.shaded.org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.qubership.profiler.shaded.org.springframework.boot.context.event.ApplicationReadyEvent;
import org.qubership.profiler.shaded.org.springframework.boot.context.event.ApplicationStartedEvent;
import org.qubership.profiler.shaded.org.springframework.boot.context.event.SpringApplicationEvent;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContextAware;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationListener;
import org.qubership.profiler.shaded.org.springframework.context.ConfigurableApplicationContext;
import org.qubership.profiler.shaded.org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.qubership.profiler.shaded.org.springframework.core.Ordered;
import org.qubership.profiler.shaded.org.springframework.core.env.ConfigurableEnvironment;
import org.qubership.profiler.shaded.org.springframework.util.ErrorHandler;

public class EventPublishingRunListener
implements SpringApplicationRunListener,
Ordered {
    private final SpringApplication application;
    private final String[] args;
    private final SimpleApplicationEventMulticaster initialMulticaster;

    public EventPublishingRunListener(SpringApplication application, String[] args) {
        this.application = application;
        this.args = args;
        this.initialMulticaster = new SimpleApplicationEventMulticaster();
        for (ApplicationListener<?> listener : application.getListeners()) {
            this.initialMulticaster.addApplicationListener(listener);
        }
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void starting() {
        this.initialMulticaster.multicastEvent(new ApplicationStartedEvent(this.application, this.args));
    }

    @Override
    public void environmentPrepared(ConfigurableEnvironment environment) {
        this.initialMulticaster.multicastEvent(new ApplicationEnvironmentPreparedEvent(this.application, this.args, environment));
    }

    @Override
    public void contextPrepared(ConfigurableApplicationContext context) {
    }

    @Override
    public void contextLoaded(ConfigurableApplicationContext context) {
        for (ApplicationListener<?> listener : this.application.getListeners()) {
            if (listener instanceof ApplicationContextAware) {
                ((ApplicationContextAware)((Object)listener)).setApplicationContext(context);
            }
            context.addApplicationListener(listener);
        }
        this.initialMulticaster.multicastEvent(new ApplicationPreparedEvent(this.application, this.args, context));
    }

    @Override
    public void finished(ConfigurableApplicationContext context, Throwable exception) {
        SpringApplicationEvent event = this.getFinishedEvent(context, exception);
        if (context != null) {
            context.publishEvent(event);
        } else {
            if (event instanceof ApplicationFailedEvent) {
                this.initialMulticaster.setErrorHandler(new LoggingErrorHandler());
            }
            this.initialMulticaster.multicastEvent(event);
        }
    }

    private SpringApplicationEvent getFinishedEvent(ConfigurableApplicationContext context, Throwable exception) {
        if (exception != null) {
            return new ApplicationFailedEvent(this.application, this.args, context, exception);
        }
        return new ApplicationReadyEvent(this.application, this.args, context);
    }

    private static class LoggingErrorHandler
    implements ErrorHandler {
        private static Log logger = LogFactory.getLog(EventPublishingRunListener.class);

        private LoggingErrorHandler() {
        }

        @Override
        public void handleError(Throwable throwable) {
            logger.warn("Error calling ApplicationEventListener", throwable);
        }
    }
}

