/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.liquibase;

import java.io.IOException;
import liquibase.servicelocator.DefaultPackageScanClassResolver;
import org.qubership.profiler.shaded.org.apache.commons.logging.Log;
import org.qubership.profiler.shaded.org.springframework.core.io.Resource;
import org.qubership.profiler.shaded.org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.qubership.profiler.shaded.org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.qubership.profiler.shaded.org.springframework.core.type.classreading.MetadataReader;
import org.qubership.profiler.shaded.org.springframework.core.type.classreading.MetadataReaderFactory;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;

public class SpringPackageScanClassResolver
extends DefaultPackageScanClassResolver {
    private final Log logger;

    public SpringPackageScanClassResolver(Log logger) {
        this.logger = logger;
    }

    protected void findAllClasses(String packageName, ClassLoader loader) {
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory(loader);
        try {
            Resource[] resources;
            for (Resource resource : resources = this.scan(loader, packageName)) {
                Class<?> clazz = this.loadClass(loader, metadataReaderFactory, resource);
                if (clazz == null) continue;
                this.addFoundClass(clazz);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Resource[] scan(ClassLoader loader, String packageName) throws IOException {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(loader);
        String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath(packageName) + "/**/*.class";
        Resource[] resources = resolver.getResources(pattern);
        return resources;
    }

    private Class<?> loadClass(ClassLoader loader, MetadataReaderFactory readerFactory, Resource resource) {
        try {
            MetadataReader reader = readerFactory.getMetadataReader(resource);
            return ClassUtils.forName(reader.getClassMetadata().getClassName(), loader);
        }
        catch (ClassNotFoundException ex) {
            this.handleFailure(resource, ex);
            return null;
        }
        catch (LinkageError ex) {
            this.handleFailure(resource, ex);
            return null;
        }
        catch (Throwable ex) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Unexpected failure when loading class resource " + resource, ex);
            }
            return null;
        }
    }

    private void handleFailure(Resource resource, Throwable ex) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignoring candidate class resource " + resource + " due to " + ex);
        }
    }
}

