/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.logging;

import java.util.ArrayList;
import java.util.List;
import org.qubership.profiler.shaded.org.apache.commons.logging.Log;
import org.qubership.profiler.shaded.org.apache.commons.logging.LogFactory;
import org.qubership.profiler.shaded.org.springframework.boot.logging.LogLevel;

public class DeferredLog
implements Log {
    private List<Line> lines = new ArrayList<Line>();

    @Override
    public boolean isTraceEnabled() {
        return true;
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public boolean isFatalEnabled() {
        return true;
    }

    @Override
    public void trace(Object message) {
        this.log(LogLevel.TRACE, message, null);
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.log(LogLevel.TRACE, message, t);
    }

    @Override
    public void debug(Object message) {
        this.log(LogLevel.DEBUG, message, null);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.log(LogLevel.DEBUG, message, t);
    }

    @Override
    public void info(Object message) {
        this.log(LogLevel.INFO, message, null);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.log(LogLevel.INFO, message, t);
    }

    @Override
    public void warn(Object message) {
        this.log(LogLevel.WARN, message, null);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.log(LogLevel.WARN, message, t);
    }

    @Override
    public void error(Object message) {
        this.log(LogLevel.ERROR, message, null);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.log(LogLevel.ERROR, message, t);
    }

    @Override
    public void fatal(Object message) {
        this.log(LogLevel.FATAL, message, null);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.log(LogLevel.FATAL, message, t);
    }

    private void log(LogLevel level, Object message, Throwable t) {
        this.lines.add(new Line(level, message, t));
    }

    public void replayTo(Class<?> destination) {
        this.replayTo(LogFactory.getLog(destination));
    }

    public void replayTo(Log destination) {
        for (Line line : this.lines) {
            line.replayTo(destination);
        }
        this.lines.clear();
    }

    public static Log replay(Log source, Class<?> destination) {
        return DeferredLog.replay(source, LogFactory.getLog(destination));
    }

    public static Log replay(Log source, Log destination) {
        if (source instanceof DeferredLog) {
            ((DeferredLog)source).replayTo(destination);
        }
        return destination;
    }

    private static class Line {
        private final LogLevel level;
        private final Object message;
        private final Throwable throwable;

        Line(LogLevel level, Object message, Throwable throwable) {
            this.level = level;
            this.message = message;
            this.throwable = throwable;
        }

        public void replayTo(Log log) {
            switch (this.level) {
                case TRACE: {
                    log.trace(this.message, this.throwable);
                    return;
                }
                case DEBUG: {
                    log.debug(this.message, this.throwable);
                    return;
                }
                case INFO: {
                    log.info(this.message, this.throwable);
                    return;
                }
                case WARN: {
                    log.warn(this.message, this.throwable);
                    return;
                }
                case ERROR: {
                    log.error(this.message, this.throwable);
                    return;
                }
                case FATAL: {
                    log.fatal(this.message, this.throwable);
                    return;
                }
            }
        }
    }
}

