/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.logging;

import org.qubership.profiler.shaded.org.springframework.boot.logging.LogLevel;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.ObjectUtils;

public final class LoggerConfiguration {
    private final String name;
    private final LogLevel configuredLevel;
    private final LogLevel effectiveLevel;

    public LoggerConfiguration(String name, LogLevel configuredLevel, LogLevel effectiveLevel) {
        Assert.notNull(name, "Name must not be null");
        Assert.notNull((Object)effectiveLevel, "EffectiveLevel must not be null");
        this.name = name;
        this.configuredLevel = configuredLevel;
        this.effectiveLevel = effectiveLevel;
    }

    public LogLevel getConfiguredLevel() {
        return this.configuredLevel;
    }

    public LogLevel getEffectiveLevel() {
        return this.effectiveLevel;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "LoggerConfiguration [name=" + this.name + ", configuredLevel=" + (Object)((Object)this.configuredLevel) + ", effectiveLevel=" + (Object)((Object)this.effectiveLevel) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.name);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.configuredLevel);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.effectiveLevel);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof LoggerConfiguration) {
            LoggerConfiguration other = (LoggerConfiguration)obj;
            boolean rtn = true;
            rtn &= ObjectUtils.nullSafeEquals(this.name, other.name);
            rtn &= ObjectUtils.nullSafeEquals((Object)this.configuredLevel, (Object)other.configuredLevel);
            return rtn &= ObjectUtils.nullSafeEquals((Object)this.effectiveLevel, (Object)other.effectiveLevel);
        }
        return super.equals(obj);
    }
}

