/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.logging;

import org.qubership.profiler.shaded.org.slf4j.bridge.SLF4JBridgeHandler;
import org.qubership.profiler.shaded.org.springframework.boot.logging.AbstractLoggingSystem;
import org.qubership.profiler.shaded.org.springframework.boot.logging.LogFile;
import org.qubership.profiler.shaded.org.springframework.boot.logging.LoggingInitializationContext;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;

public abstract class Slf4JLoggingSystem
extends AbstractLoggingSystem {
    private static final String BRIDGE_HANDLER = "org.qubership.profiler.shaded.org.slf4j.bridge.SLF4JBridgeHandler";

    public Slf4JLoggingSystem(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    public void beforeInitialize() {
        super.beforeInitialize();
        this.configureJdkLoggingBridgeHandler();
    }

    @Override
    public void cleanUp() {
        this.removeJdkLoggingBridgeHandler();
    }

    @Override
    protected void loadConfiguration(LoggingInitializationContext initializationContext, String location, LogFile logFile) {
        Assert.notNull(location, "Location must not be null");
        if (initializationContext != null) {
            this.applySystemProperties(initializationContext.getEnvironment(), logFile);
        }
    }

    private void configureJdkLoggingBridgeHandler() {
        try {
            if (this.isBridgeHandlerAvailable()) {
                this.removeJdkLoggingBridgeHandler();
                SLF4JBridgeHandler.install();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected final boolean isBridgeHandlerAvailable() {
        return ClassUtils.isPresent(BRIDGE_HANDLER, this.getClassLoader());
    }

    private void removeJdkLoggingBridgeHandler() {
        try {
            if (this.isBridgeHandlerAvailable()) {
                try {
                    SLF4JBridgeHandler.removeHandlersForRootLogger();
                }
                catch (NoSuchMethodError ex) {
                    SLF4JBridgeHandler.uninstall();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

