/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.logging.logback;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.qubership.profiler.shaded.ch.qos.logback.classic.Level;
import org.qubership.profiler.shaded.ch.qos.logback.classic.spi.ILoggingEvent;
import org.qubership.profiler.shaded.ch.qos.logback.core.pattern.CompositeConverter;
import org.qubership.profiler.shaded.org.springframework.boot.ansi.AnsiColor;
import org.qubership.profiler.shaded.org.springframework.boot.ansi.AnsiElement;
import org.qubership.profiler.shaded.org.springframework.boot.ansi.AnsiOutput;
import org.qubership.profiler.shaded.org.springframework.boot.ansi.AnsiStyle;

public class ColorConverter
extends CompositeConverter<ILoggingEvent> {
    private static final Map<String, AnsiElement> ELEMENTS;
    private static final Map<Integer, AnsiElement> LEVELS;

    @Override
    protected String transform(ILoggingEvent event, String in) {
        AnsiElement element = ELEMENTS.get(this.getFirstOption());
        if (element == null) {
            element = LEVELS.get(event.getLevel().toInteger());
            element = element == null ? AnsiColor.GREEN : element;
        }
        return this.toAnsiString(in, element);
    }

    protected String toAnsiString(String in, AnsiElement element) {
        return AnsiOutput.toString(element, in);
    }

    static {
        HashMap<String, Enum> elements = new HashMap<String, Enum>();
        elements.put("faint", AnsiStyle.FAINT);
        elements.put("red", AnsiColor.RED);
        elements.put("green", AnsiColor.GREEN);
        elements.put("yellow", AnsiColor.YELLOW);
        elements.put("blue", AnsiColor.BLUE);
        elements.put("magenta", AnsiColor.MAGENTA);
        elements.put("cyan", AnsiColor.CYAN);
        ELEMENTS = Collections.unmodifiableMap(elements);
        HashMap<Integer, AnsiColor> levels = new HashMap<Integer, AnsiColor>();
        levels.put(Level.ERROR_INTEGER, AnsiColor.RED);
        levels.put(Level.WARN_INTEGER, AnsiColor.YELLOW);
        LEVELS = Collections.unmodifiableMap(levels);
    }
}

