/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.logging.logback;

import java.util.HashMap;
import org.qubership.profiler.shaded.ch.qos.logback.classic.Level;
import org.qubership.profiler.shaded.ch.qos.logback.classic.Logger;
import org.qubership.profiler.shaded.ch.qos.logback.classic.LoggerContext;
import org.qubership.profiler.shaded.ch.qos.logback.classic.spi.ILoggingEvent;
import org.qubership.profiler.shaded.ch.qos.logback.core.Appender;
import org.qubership.profiler.shaded.ch.qos.logback.core.pattern.Converter;
import org.qubership.profiler.shaded.ch.qos.logback.core.spi.ContextAware;
import org.qubership.profiler.shaded.ch.qos.logback.core.spi.LifeCycle;
import org.qubership.profiler.shaded.ch.qos.logback.core.spi.PropertyContainer;
import org.qubership.profiler.shaded.org.springframework.util.Assert;

class LogbackConfigurator {
    private LoggerContext context;

    LogbackConfigurator(LoggerContext context) {
        Assert.notNull(context, "Context must not be null");
        this.context = context;
    }

    public PropertyContainer getContext() {
        return this.context;
    }

    public Object getConfigurationLock() {
        return this.context.getConfigurationLock();
    }

    public void conversionRule(String conversionWord, Class<? extends Converter> converterClass) {
        Assert.hasLength(conversionWord, "Conversion word must not be empty");
        Assert.notNull(converterClass, "Converter class must not be null");
        HashMap<String, String> registry = (HashMap<String, String>)this.context.getObject("PATTERN_RULE_REGISTRY");
        if (registry == null) {
            registry = new HashMap<String, String>();
            this.context.putObject("PATTERN_RULE_REGISTRY", registry);
        }
        registry.put(conversionWord, converterClass.getName());
    }

    public void appender(String name, Appender<?> appender) {
        appender.setName(name);
        this.start(appender);
    }

    public void logger(String name, Level level) {
        this.logger(name, level, true);
    }

    public void logger(String name, Level level, boolean additive) {
        this.logger(name, level, additive, null);
    }

    public void logger(String name, Level level, boolean additive, Appender<ILoggingEvent> appender) {
        Logger logger = this.context.getLogger(name);
        if (level != null) {
            logger.setLevel(level);
        }
        logger.setAdditive(additive);
        if (appender != null) {
            logger.addAppender(appender);
        }
    }

    @SafeVarargs
    public final void root(Level level, Appender<ILoggingEvent> ... appenders) {
        Logger logger = this.context.getLogger("ROOT");
        if (level != null) {
            logger.setLevel(level);
        }
        for (Appender<ILoggingEvent> appender : appenders) {
            logger.addAppender(appender);
        }
    }

    public void start(LifeCycle lifeCycle) {
        if (lifeCycle instanceof ContextAware) {
            ((ContextAware)((Object)lifeCycle)).setContext(this.context);
        }
        lifeCycle.start();
    }
}

