/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.web.servlet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.qubership.profiler.shaded.org.springframework.beans.BeansException;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.BeanPostProcessor;
import org.qubership.profiler.shaded.org.springframework.boot.web.servlet.ErrorPageRegistrar;
import org.qubership.profiler.shaded.org.springframework.boot.web.servlet.ErrorPageRegistry;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContext;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContextAware;
import org.qubership.profiler.shaded.org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class ErrorPageRegistrarBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private List<ErrorPageRegistrar> registrars;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ErrorPageRegistry) {
            this.postProcessBeforeInitialization((ErrorPageRegistry)bean);
        }
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void postProcessBeforeInitialization(ErrorPageRegistry registry) {
        for (ErrorPageRegistrar registrar : this.getRegistrars()) {
            registrar.registerErrorPages(registry);
        }
    }

    private Collection<ErrorPageRegistrar> getRegistrars() {
        if (this.registrars == null) {
            this.registrars = new ArrayList<ErrorPageRegistrar>(this.applicationContext.getBeansOfType(ErrorPageRegistrar.class, false, false).values());
            Collections.sort(this.registrars, AnnotationAwareOrderComparator.INSTANCE);
            this.registrars = Collections.unmodifiableList(this.registrars);
        }
        return this.registrars;
    }
}

