/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.web.servlet;

import java.util.Map;
import javax.servlet.MultipartConfigElement;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.BeanDefinition;
import org.qubership.profiler.shaded.org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.qubership.profiler.shaded.org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.qubership.profiler.shaded.org.springframework.boot.web.servlet.ServletComponentHandler;
import org.qubership.profiler.shaded.org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;

class WebServletHandler
extends ServletComponentHandler {
    WebServletHandler() {
        super(WebServlet.class);
    }

    @Override
    public void doHandle(Map<String, Object> attributes, ScannedGenericBeanDefinition beanDefinition, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ServletRegistrationBean.class);
        builder.addPropertyValue("asyncSupported", attributes.get("asyncSupported"));
        builder.addPropertyValue("initParameters", this.extractInitParameters(attributes));
        builder.addPropertyValue("loadOnStartup", attributes.get("loadOnStartup"));
        String name = this.determineName(attributes, beanDefinition);
        builder.addPropertyValue("name", name);
        builder.addPropertyValue("servlet", beanDefinition);
        builder.addPropertyValue("urlMappings", this.extractUrlPatterns("urlPatterns", attributes));
        builder.addPropertyValue("multipartConfig", this.determineMultipartConfig(beanDefinition));
        registry.registerBeanDefinition(name, builder.getBeanDefinition());
    }

    private String determineName(Map<String, Object> attributes, BeanDefinition beanDefinition) {
        return (String)(StringUtils.hasText((String)attributes.get("name")) ? attributes.get("name") : beanDefinition.getBeanClassName());
    }

    private MultipartConfigElement determineMultipartConfig(ScannedGenericBeanDefinition beanDefinition) {
        Map<String, Object> attributes = beanDefinition.getMetadata().getAnnotationAttributes(MultipartConfig.class.getName());
        if (attributes == null) {
            return null;
        }
        return new MultipartConfigElement((String)attributes.get("location"), (Long)attributes.get("maxFileSize"), (Long)attributes.get("maxRequestSize"), (Integer)attributes.get("fileSizeThreshold"));
    }
}

