/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.context.annotation;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.qubership.profiler.shaded.org.apache.commons.logging.Log;
import org.qubership.profiler.shaded.org.apache.commons.logging.LogFactory;
import org.qubership.profiler.shaded.org.springframework.aop.framework.autoproxy.AutoProxyUtils;
import org.qubership.profiler.shaded.org.springframework.beans.PropertyValues;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanClassLoaderAware;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanDefinitionStoreException;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.BeanDefinition;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.qubership.profiler.shaded.org.springframework.beans.factory.parsing.FailFastProblemReporter;
import org.qubership.profiler.shaded.org.springframework.beans.factory.parsing.PassThroughSourceExtractor;
import org.qubership.profiler.shaded.org.springframework.beans.factory.parsing.ProblemReporter;
import org.qubership.profiler.shaded.org.springframework.beans.factory.parsing.SourceExtractor;
import org.qubership.profiler.shaded.org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.qubership.profiler.shaded.org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.qubership.profiler.shaded.org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.qubership.profiler.shaded.org.springframework.beans.factory.support.BeanNameGenerator;
import org.qubership.profiler.shaded.org.springframework.context.EnvironmentAware;
import org.qubership.profiler.shaded.org.springframework.context.ResourceLoaderAware;
import org.qubership.profiler.shaded.org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ConfigurationClass;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ConfigurationClassBeanDefinitionReader;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ConfigurationClassEnhancer;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ConfigurationClassParser;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ConfigurationClassUtils;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ImportAware;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ImportRegistry;
import org.qubership.profiler.shaded.org.springframework.core.PriorityOrdered;
import org.qubership.profiler.shaded.org.springframework.core.env.Environment;
import org.qubership.profiler.shaded.org.springframework.core.io.DefaultResourceLoader;
import org.qubership.profiler.shaded.org.springframework.core.io.ResourceLoader;
import org.qubership.profiler.shaded.org.springframework.core.type.AnnotationMetadata;
import org.qubership.profiler.shaded.org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.qubership.profiler.shaded.org.springframework.core.type.classreading.MetadataReaderFactory;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;

public class ConfigurationClassPostProcessor
implements BeanDefinitionRegistryPostProcessor,
PriorityOrdered,
ResourceLoaderAware,
BeanClassLoaderAware,
EnvironmentAware {
    private static final String IMPORT_REGISTRY_BEAN_NAME = ConfigurationClassPostProcessor.class.getName() + ".importRegistry";
    private final Log logger = LogFactory.getLog(this.getClass());
    private SourceExtractor sourceExtractor = new PassThroughSourceExtractor();
    private ProblemReporter problemReporter = new FailFastProblemReporter();
    private Environment environment;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory();
    private boolean setMetadataReaderFactoryCalled = false;
    private final Set<Integer> registriesPostProcessed = new HashSet<Integer>();
    private final Set<Integer> factoriesPostProcessed = new HashSet<Integer>();
    private ConfigurationClassBeanDefinitionReader reader;
    private boolean localBeanNameGeneratorSet = false;
    private BeanNameGenerator componentScanBeanNameGenerator = new AnnotationBeanNameGenerator();
    private BeanNameGenerator importBeanNameGenerator = new AnnotationBeanNameGenerator(){

        @Override
        protected String buildDefaultBeanName(BeanDefinition definition) {
            return definition.getBeanClassName();
        }
    };

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setSourceExtractor(SourceExtractor sourceExtractor) {
        this.sourceExtractor = sourceExtractor != null ? sourceExtractor : new PassThroughSourceExtractor();
    }

    public void setProblemReporter(ProblemReporter problemReporter) {
        this.problemReporter = problemReporter != null ? problemReporter : new FailFastProblemReporter();
    }

    public void setMetadataReaderFactory(MetadataReaderFactory metadataReaderFactory) {
        Assert.notNull(metadataReaderFactory, "MetadataReaderFactory must not be null");
        this.metadataReaderFactory = metadataReaderFactory;
        this.setMetadataReaderFactoryCalled = true;
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        Assert.notNull(beanNameGenerator, "BeanNameGenerator must not be null");
        this.localBeanNameGeneratorSet = true;
        this.componentScanBeanNameGenerator = beanNameGenerator;
        this.importBeanNameGenerator = beanNameGenerator;
    }

    @Override
    public void setEnvironment(Environment environment) {
        Assert.notNull(environment, "Environment must not be null");
        this.environment = environment;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        Assert.notNull(resourceLoader, "ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
        if (!this.setMetadataReaderFactoryCalled) {
            this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
        }
    }

    @Override
    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
        if (!this.setMetadataReaderFactoryCalled) {
            this.metadataReaderFactory = new CachingMetadataReaderFactory(beanClassLoader);
        }
    }

    @Override
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) {
        int registryId = System.identityHashCode(registry);
        if (this.registriesPostProcessed.contains(registryId)) {
            throw new IllegalStateException("postProcessBeanDefinitionRegistry already called on this post-processor against " + registry);
        }
        if (this.factoriesPostProcessed.contains(registryId)) {
            throw new IllegalStateException("postProcessBeanFactory already called on this post-processor against " + registry);
        }
        this.registriesPostProcessed.add(registryId);
        this.processConfigBeanDefinitions(registry);
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        int factoryId = System.identityHashCode(beanFactory);
        if (this.factoriesPostProcessed.contains(factoryId)) {
            throw new IllegalStateException("postProcessBeanFactory already called on this post-processor against " + beanFactory);
        }
        this.factoriesPostProcessed.add(factoryId);
        if (!this.registriesPostProcessed.contains(factoryId)) {
            this.processConfigBeanDefinitions((BeanDefinitionRegistry)((Object)beanFactory));
        }
        this.enhanceConfigurationClasses(beanFactory);
        beanFactory.addBeanPostProcessor(new ImportAwareBeanPostProcessor(beanFactory));
    }

    public void processConfigBeanDefinitions(BeanDefinitionRegistry registry) {
        String[] candidateNames;
        ArrayList<BeanDefinitionHolder> configCandidates = new ArrayList<BeanDefinitionHolder>();
        for (String beanName : candidateNames = registry.getBeanDefinitionNames()) {
            BeanDefinition beanDef = registry.getBeanDefinition(beanName);
            if (ConfigurationClassUtils.isFullConfigurationClass(beanDef) || ConfigurationClassUtils.isLiteConfigurationClass(beanDef)) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Bean definition has already been processed as a configuration class: " + beanDef);
                continue;
            }
            if (!ConfigurationClassUtils.checkConfigurationClassCandidate(beanDef, this.metadataReaderFactory)) continue;
            configCandidates.add(new BeanDefinitionHolder(beanDef, beanName));
        }
        if (configCandidates.isEmpty()) {
            return;
        }
        Collections.sort(configCandidates, new Comparator<BeanDefinitionHolder>(){

            @Override
            public int compare(BeanDefinitionHolder bd1, BeanDefinitionHolder bd2) {
                int i2;
                int i1 = ConfigurationClassUtils.getOrder(bd1.getBeanDefinition());
                return i1 < (i2 = ConfigurationClassUtils.getOrder(bd2.getBeanDefinition())) ? -1 : (i1 > i2 ? 1 : 0);
            }
        });
        SingletonBeanRegistry singletonRegistry = null;
        if (registry instanceof SingletonBeanRegistry) {
            singletonRegistry = (SingletonBeanRegistry)((Object)registry);
            if (!this.localBeanNameGeneratorSet && singletonRegistry.containsSingleton("org.qubership.profiler.shaded.org.springframework.context.annotation.internalConfigurationBeanNameGenerator")) {
                BeanNameGenerator generator;
                this.componentScanBeanNameGenerator = generator = (BeanNameGenerator)singletonRegistry.getSingleton("org.qubership.profiler.shaded.org.springframework.context.annotation.internalConfigurationBeanNameGenerator");
                this.importBeanNameGenerator = generator;
            }
        }
        ConfigurationClassParser parser = new ConfigurationClassParser(this.metadataReaderFactory, this.problemReporter, this.environment, this.resourceLoader, this.componentScanBeanNameGenerator, registry);
        LinkedHashSet<BeanDefinitionHolder> candidates = new LinkedHashSet<BeanDefinitionHolder>(configCandidates);
        HashSet<ConfigurationClass> alreadyParsed = new HashSet<ConfigurationClass>(configCandidates.size());
        do {
            parser.parse(candidates);
            parser.validate();
            LinkedHashSet<ConfigurationClass> configClasses = new LinkedHashSet<ConfigurationClass>(parser.getConfigurationClasses());
            configClasses.removeAll(alreadyParsed);
            if (this.reader == null) {
                this.reader = new ConfigurationClassBeanDefinitionReader(registry, this.sourceExtractor, this.resourceLoader, this.environment, this.importBeanNameGenerator, parser.getImportRegistry());
            }
            this.reader.loadBeanDefinitions(configClasses);
            alreadyParsed.addAll(configClasses);
            candidates.clear();
            if (registry.getBeanDefinitionCount() <= candidateNames.length) continue;
            String[] newCandidateNames = registry.getBeanDefinitionNames();
            HashSet<String> oldCandidateNames = new HashSet<String>(Arrays.asList(candidateNames));
            HashSet<String> alreadyParsedClasses = new HashSet<String>();
            for (ConfigurationClass configurationClass : alreadyParsed) {
                alreadyParsedClasses.add(configurationClass.getMetadata().getClassName());
            }
            for (String candidateName : newCandidateNames) {
                BeanDefinition beanDef;
                if (oldCandidateNames.contains(candidateName) || !ConfigurationClassUtils.checkConfigurationClassCandidate(beanDef = registry.getBeanDefinition(candidateName), this.metadataReaderFactory) || alreadyParsedClasses.contains(beanDef.getBeanClassName())) continue;
                candidates.add(new BeanDefinitionHolder(beanDef, candidateName));
            }
            candidateNames = newCandidateNames;
        } while (!candidates.isEmpty());
        if (singletonRegistry != null && !singletonRegistry.containsSingleton(IMPORT_REGISTRY_BEAN_NAME)) {
            singletonRegistry.registerSingleton(IMPORT_REGISTRY_BEAN_NAME, parser.getImportRegistry());
        }
        if (this.metadataReaderFactory instanceof CachingMetadataReaderFactory) {
            ((CachingMetadataReaderFactory)this.metadataReaderFactory).clearCache();
        }
    }

    public void enhanceConfigurationClasses(ConfigurableListableBeanFactory beanFactory) {
        LinkedHashMap<String, AbstractBeanDefinition> configBeanDefs = new LinkedHashMap<String, AbstractBeanDefinition>();
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDef = beanFactory.getBeanDefinition(beanName);
            if (!ConfigurationClassUtils.isFullConfigurationClass(beanDef)) continue;
            if (!(beanDef instanceof AbstractBeanDefinition)) {
                throw new BeanDefinitionStoreException("Cannot enhance @Configuration bean definition '" + beanName + "' since it is not stored in an AbstractBeanDefinition subclass");
            }
            if (this.logger.isWarnEnabled() && beanFactory.containsSingleton(beanName)) {
                this.logger.warn("Cannot enhance @Configuration bean definition '" + beanName + "' since its singleton instance has been created too early. The typical cause is a non-static @Bean method with a BeanDefinitionRegistryPostProcessor return type: Consider declaring such methods as 'static'.");
            }
            configBeanDefs.put(beanName, (AbstractBeanDefinition)beanDef);
        }
        if (configBeanDefs.isEmpty()) {
            return;
        }
        ConfigurationClassEnhancer enhancer = new ConfigurationClassEnhancer();
        for (Map.Entry entry : configBeanDefs.entrySet()) {
            AbstractBeanDefinition beanDef = (AbstractBeanDefinition)entry.getValue();
            beanDef.setAttribute(AutoProxyUtils.PRESERVE_TARGET_CLASS_ATTRIBUTE, Boolean.TRUE);
            try {
                Class<?> enhancedClass;
                Class<?> configClass = beanDef.resolveBeanClass(this.beanClassLoader);
                if (configClass == (enhancedClass = enhancer.enhance(configClass, this.beanClassLoader))) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(String.format("Replacing bean definition '%s' existing class '%s' with enhanced class '%s'", entry.getKey(), configClass.getName(), enhancedClass.getName()));
                }
                beanDef.setBeanClass(enhancedClass);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Cannot load configuration class: " + beanDef.getBeanClassName(), ex);
            }
        }
    }

    private static class ImportAwareBeanPostProcessor
    extends InstantiationAwareBeanPostProcessorAdapter {
        private final BeanFactory beanFactory;

        public ImportAwareBeanPostProcessor(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        @Override
        public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) {
            if (bean instanceof ConfigurationClassEnhancer.EnhancedConfiguration) {
                ((ConfigurationClassEnhancer.EnhancedConfiguration)bean).setBeanFactory(this.beanFactory);
            }
            return pvs;
        }

        @Override
        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            ImportRegistry importRegistry;
            AnnotationMetadata importingClass;
            if (bean instanceof ImportAware && (importingClass = (importRegistry = this.beanFactory.getBean(IMPORT_REGISTRY_BEAN_NAME, ImportRegistry.class)).getImportingClassFor(bean.getClass().getSuperclass().getName())) != null) {
                ((ImportAware)bean).setImportMetadata(importingClass);
            }
            return bean;
        }
    }
}

