/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.context.i18n;

import java.util.Locale;
import java.util.TimeZone;
import org.qubership.profiler.shaded.org.springframework.context.i18n.LocaleContext;
import org.qubership.profiler.shaded.org.springframework.context.i18n.SimpleLocaleContext;
import org.qubership.profiler.shaded.org.springframework.context.i18n.SimpleTimeZoneAwareLocaleContext;
import org.qubership.profiler.shaded.org.springframework.context.i18n.TimeZoneAwareLocaleContext;
import org.qubership.profiler.shaded.org.springframework.core.NamedInheritableThreadLocal;
import org.qubership.profiler.shaded.org.springframework.core.NamedThreadLocal;

public abstract class LocaleContextHolder {
    private static final ThreadLocal<LocaleContext> localeContextHolder = new NamedThreadLocal<LocaleContext>("LocaleContext");
    private static final ThreadLocal<LocaleContext> inheritableLocaleContextHolder = new NamedInheritableThreadLocal<LocaleContext>("LocaleContext");
    private static Locale defaultLocale;
    private static TimeZone defaultTimeZone;

    public static void resetLocaleContext() {
        localeContextHolder.remove();
        inheritableLocaleContextHolder.remove();
    }

    public static void setLocaleContext(LocaleContext localeContext) {
        LocaleContextHolder.setLocaleContext(localeContext, false);
    }

    public static void setLocaleContext(LocaleContext localeContext, boolean inheritable) {
        if (localeContext == null) {
            LocaleContextHolder.resetLocaleContext();
        } else if (inheritable) {
            inheritableLocaleContextHolder.set(localeContext);
            localeContextHolder.remove();
        } else {
            localeContextHolder.set(localeContext);
            inheritableLocaleContextHolder.remove();
        }
    }

    public static LocaleContext getLocaleContext() {
        LocaleContext localeContext = localeContextHolder.get();
        if (localeContext == null) {
            localeContext = inheritableLocaleContextHolder.get();
        }
        return localeContext;
    }

    public static void setLocale(Locale locale) {
        LocaleContextHolder.setLocale(locale, false);
    }

    public static void setLocale(Locale locale, boolean inheritable) {
        TimeZone timeZone;
        LocaleContext localeContext = LocaleContextHolder.getLocaleContext();
        TimeZone timeZone2 = timeZone = localeContext instanceof TimeZoneAwareLocaleContext ? ((TimeZoneAwareLocaleContext)localeContext).getTimeZone() : null;
        localeContext = timeZone != null ? new SimpleTimeZoneAwareLocaleContext(locale, timeZone) : (locale != null ? new SimpleLocaleContext(locale) : null);
        LocaleContextHolder.setLocaleContext(localeContext, inheritable);
    }

    public static void setDefaultLocale(Locale locale) {
        defaultLocale = locale;
    }

    public static Locale getLocale() {
        Locale locale;
        LocaleContext localeContext = LocaleContextHolder.getLocaleContext();
        if (localeContext != null && (locale = localeContext.getLocale()) != null) {
            return locale;
        }
        return defaultLocale != null ? defaultLocale : Locale.getDefault();
    }

    public static void setTimeZone(TimeZone timeZone) {
        LocaleContextHolder.setTimeZone(timeZone, false);
    }

    public static void setTimeZone(TimeZone timeZone, boolean inheritable) {
        Locale locale;
        LocaleContext localeContext = LocaleContextHolder.getLocaleContext();
        Locale locale2 = locale = localeContext != null ? localeContext.getLocale() : null;
        localeContext = timeZone != null ? new SimpleTimeZoneAwareLocaleContext(locale, timeZone) : (locale != null ? new SimpleLocaleContext(locale) : null);
        LocaleContextHolder.setLocaleContext(localeContext, inheritable);
    }

    public static void setDefaultTimeZone(TimeZone timeZone) {
        defaultTimeZone = timeZone;
    }

    public static TimeZone getTimeZone() {
        TimeZone timeZone;
        LocaleContext localeContext = LocaleContextHolder.getLocaleContext();
        if (localeContext instanceof TimeZoneAwareLocaleContext && (timeZone = ((TimeZoneAwareLocaleContext)localeContext).getTimeZone()) != null) {
            return timeZone;
        }
        return defaultTimeZone != null ? defaultTimeZone : TimeZone.getDefault();
    }
}

