/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.qubership.profiler.shaded.org.springframework.core.ParameterNameDiscoverer;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;

public class MethodParameter {
    private static final Class<?> javaUtilOptionalClass;
    private final Method method;
    private final Constructor<?> constructor;
    private final int parameterIndex;
    private int nestingLevel = 1;
    Map<Integer, Integer> typeIndexesPerLevel;
    private volatile Class<?> containingClass;
    private volatile Class<?> parameterType;
    private volatile Type genericParameterType;
    private volatile Annotation[] parameterAnnotations;
    private volatile ParameterNameDiscoverer parameterNameDiscoverer;
    private volatile String parameterName;
    private volatile MethodParameter nestedMethodParameter;

    public MethodParameter(Method method, int parameterIndex) {
        this(method, parameterIndex, 1);
    }

    public MethodParameter(Method method, int parameterIndex, int nestingLevel) {
        Assert.notNull(method, "Method must not be null");
        this.method = method;
        this.parameterIndex = parameterIndex;
        this.nestingLevel = nestingLevel;
        this.constructor = null;
    }

    public MethodParameter(Constructor<?> constructor, int parameterIndex) {
        this(constructor, parameterIndex, 1);
    }

    public MethodParameter(Constructor<?> constructor, int parameterIndex, int nestingLevel) {
        Assert.notNull(constructor, "Constructor must not be null");
        this.constructor = constructor;
        this.parameterIndex = parameterIndex;
        this.nestingLevel = nestingLevel;
        this.method = null;
    }

    public MethodParameter(MethodParameter original) {
        Assert.notNull(original, "Original must not be null");
        this.method = original.method;
        this.constructor = original.constructor;
        this.parameterIndex = original.parameterIndex;
        this.nestingLevel = original.nestingLevel;
        this.typeIndexesPerLevel = original.typeIndexesPerLevel;
        this.containingClass = original.containingClass;
        this.parameterType = original.parameterType;
        this.genericParameterType = original.genericParameterType;
        this.parameterAnnotations = original.parameterAnnotations;
        this.parameterNameDiscoverer = original.parameterNameDiscoverer;
        this.parameterName = original.parameterName;
    }

    public Method getMethod() {
        return this.method;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public Class<?> getDeclaringClass() {
        return this.getMember().getDeclaringClass();
    }

    public Member getMember() {
        if (this.method != null) {
            return this.method;
        }
        return this.constructor;
    }

    public AnnotatedElement getAnnotatedElement() {
        if (this.method != null) {
            return this.method;
        }
        return this.constructor;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public void increaseNestingLevel() {
        ++this.nestingLevel;
    }

    public void decreaseNestingLevel() {
        this.getTypeIndexesPerLevel().remove(this.nestingLevel);
        --this.nestingLevel;
    }

    public int getNestingLevel() {
        return this.nestingLevel;
    }

    public void setTypeIndexForCurrentLevel(int typeIndex) {
        this.getTypeIndexesPerLevel().put(this.nestingLevel, typeIndex);
    }

    public Integer getTypeIndexForCurrentLevel() {
        return this.getTypeIndexForLevel(this.nestingLevel);
    }

    public Integer getTypeIndexForLevel(int nestingLevel) {
        return this.getTypeIndexesPerLevel().get(nestingLevel);
    }

    private Map<Integer, Integer> getTypeIndexesPerLevel() {
        if (this.typeIndexesPerLevel == null) {
            this.typeIndexesPerLevel = new HashMap<Integer, Integer>(4);
        }
        return this.typeIndexesPerLevel;
    }

    public MethodParameter nested() {
        if (this.nestedMethodParameter != null) {
            return this.nestedMethodParameter;
        }
        MethodParameter nestedParam = this.clone();
        nestedParam.nestingLevel = this.nestingLevel + 1;
        this.nestedMethodParameter = nestedParam;
        return nestedParam;
    }

    public boolean isOptional() {
        return this.getParameterType() == javaUtilOptionalClass;
    }

    public MethodParameter nestedIfOptional() {
        return this.isOptional() ? this.nested() : this;
    }

    void setContainingClass(Class<?> containingClass) {
        this.containingClass = containingClass;
    }

    public Class<?> getContainingClass() {
        return this.containingClass != null ? this.containingClass : this.getDeclaringClass();
    }

    void setParameterType(Class<?> parameterType) {
        this.parameterType = parameterType;
    }

    public Class<?> getParameterType() {
        if (this.parameterType == null) {
            this.parameterType = this.parameterIndex < 0 ? (this.method != null ? this.method.getReturnType() : null) : (this.method != null ? this.method.getParameterTypes()[this.parameterIndex] : this.constructor.getParameterTypes()[this.parameterIndex]);
        }
        return this.parameterType;
    }

    public Type getGenericParameterType() {
        if (this.genericParameterType == null) {
            this.genericParameterType = this.parameterIndex < 0 ? (this.method != null ? this.method.getGenericReturnType() : null) : (this.method != null ? this.method.getGenericParameterTypes()[this.parameterIndex] : this.constructor.getGenericParameterTypes()[this.parameterIndex]);
        }
        return this.genericParameterType;
    }

    public Class<?> getNestedParameterType() {
        if (this.nestingLevel > 1) {
            Type arg;
            Type type = this.getGenericParameterType();
            for (int i = 2; i <= this.nestingLevel; ++i) {
                if (!(type instanceof ParameterizedType)) continue;
                Type[] args = ((ParameterizedType)type).getActualTypeArguments();
                Integer index = this.getTypeIndexForLevel(i);
                type = args[index != null ? index : args.length - 1];
            }
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType && (arg = ((ParameterizedType)type).getRawType()) instanceof Class) {
                return (Class)arg;
            }
            return Object.class;
        }
        return this.getParameterType();
    }

    public Type getNestedGenericParameterType() {
        if (this.nestingLevel > 1) {
            Type type = this.getGenericParameterType();
            for (int i = 2; i <= this.nestingLevel; ++i) {
                if (!(type instanceof ParameterizedType)) continue;
                Type[] args = ((ParameterizedType)type).getActualTypeArguments();
                Integer index = this.getTypeIndexForLevel(i);
                type = args[index != null ? index : args.length - 1];
            }
            return type;
        }
        return this.getGenericParameterType();
    }

    public Annotation[] getMethodAnnotations() {
        return this.adaptAnnotationArray(this.getAnnotatedElement().getAnnotations());
    }

    public <A extends Annotation> A getMethodAnnotation(Class<A> annotationType) {
        return this.adaptAnnotation(this.getAnnotatedElement().getAnnotation(annotationType));
    }

    public <A extends Annotation> boolean hasMethodAnnotation(Class<A> annotationType) {
        return this.getAnnotatedElement().isAnnotationPresent(annotationType);
    }

    public Annotation[] getParameterAnnotations() {
        if (this.parameterAnnotations == null) {
            Annotation[][] annotationArray = this.method != null ? this.method.getParameterAnnotations() : this.constructor.getParameterAnnotations();
            this.parameterAnnotations = this.parameterIndex >= 0 && this.parameterIndex < annotationArray.length ? this.adaptAnnotationArray(annotationArray[this.parameterIndex]) : new Annotation[0];
        }
        return this.parameterAnnotations;
    }

    public boolean hasParameterAnnotations() {
        return this.getParameterAnnotations().length != 0;
    }

    public <A extends Annotation> A getParameterAnnotation(Class<A> annotationType) {
        Annotation[] anns;
        for (Annotation ann : anns = this.getParameterAnnotations()) {
            if (!annotationType.isInstance(ann)) continue;
            return (A)ann;
        }
        return null;
    }

    public <A extends Annotation> boolean hasParameterAnnotation(Class<A> annotationType) {
        return this.getParameterAnnotation(annotationType) != null;
    }

    public void initParameterNameDiscovery(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public String getParameterName() {
        ParameterNameDiscoverer discoverer = this.parameterNameDiscoverer;
        if (discoverer != null) {
            String[] parameterNames;
            String[] stringArray = parameterNames = this.method != null ? discoverer.getParameterNames(this.method) : discoverer.getParameterNames(this.constructor);
            if (parameterNames != null) {
                this.parameterName = parameterNames[this.parameterIndex];
            }
            this.parameterNameDiscoverer = null;
        }
        return this.parameterName;
    }

    protected <A extends Annotation> A adaptAnnotation(A annotation) {
        return annotation;
    }

    protected Annotation[] adaptAnnotationArray(Annotation[] annotations) {
        return annotations;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MethodParameter)) {
            return false;
        }
        MethodParameter otherParam = (MethodParameter)other;
        return this.parameterIndex == otherParam.parameterIndex && this.getMember().equals(otherParam.getMember());
    }

    public int hashCode() {
        return this.getMember().hashCode() * 31 + this.parameterIndex;
    }

    public String toString() {
        return (this.method != null ? "method '" + this.method.getName() + "'" : "constructor") + " parameter " + this.parameterIndex;
    }

    public MethodParameter clone() {
        return new MethodParameter(this);
    }

    public static MethodParameter forMethodOrConstructor(Object methodOrConstructor, int parameterIndex) {
        if (methodOrConstructor instanceof Method) {
            return new MethodParameter((Method)methodOrConstructor, parameterIndex);
        }
        if (methodOrConstructor instanceof Constructor) {
            return new MethodParameter((Constructor)methodOrConstructor, parameterIndex);
        }
        throw new IllegalArgumentException("Given object [" + methodOrConstructor + "] is neither a Method nor a Constructor");
    }

    static {
        Class<?> clazz;
        try {
            clazz = ClassUtils.forName("java.util.Optional", MethodParameter.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            clazz = null;
        }
        javaUtilOptionalClass = clazz;
    }
}

