/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.core.convert.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.qubership.profiler.shaded.org.springframework.core.convert.ConversionService;
import org.qubership.profiler.shaded.org.springframework.core.convert.TypeDescriptor;
import org.qubership.profiler.shaded.org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.qubership.profiler.shaded.org.springframework.core.convert.converter.GenericConverter;
import org.qubership.profiler.shaded.org.springframework.core.convert.support.CollectionToArrayConverter;
import org.qubership.profiler.shaded.org.springframework.core.convert.support.GenericConversionService;
import org.qubership.profiler.shaded.org.springframework.util.ObjectUtils;

final class ArrayToArrayConverter
implements ConditionalGenericConverter {
    private final CollectionToArrayConverter helperConverter;
    private final ConversionService conversionService;

    public ArrayToArrayConverter(ConversionService conversionService) {
        this.helperConverter = new CollectionToArrayConverter(conversionService);
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object[].class, Object[].class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.helperConverter.matches(sourceType, targetType);
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (this.conversionService instanceof GenericConversionService && ((GenericConversionService)this.conversionService).canBypassConvert(sourceType.getElementTypeDescriptor(), targetType.getElementTypeDescriptor())) {
            return source;
        }
        List<Object> sourceList = Arrays.asList(ObjectUtils.toObjectArray(source));
        return this.helperConverter.convert(sourceList, sourceType, targetType);
    }
}

