/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.expression.spel.support;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.qubership.profiler.shaded.org.springframework.expression.EvaluationException;
import org.qubership.profiler.shaded.org.springframework.expression.TypeLocator;
import org.qubership.profiler.shaded.org.springframework.expression.spel.SpelEvaluationException;
import org.qubership.profiler.shaded.org.springframework.expression.spel.SpelMessage;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;

public class StandardTypeLocator
implements TypeLocator {
    private final ClassLoader classLoader;
    private final List<String> knownPackagePrefixes = new LinkedList<String>();

    public StandardTypeLocator() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public StandardTypeLocator(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.registerImport("java.lang");
    }

    public void registerImport(String prefix) {
        this.knownPackagePrefixes.add(prefix);
    }

    public void removeImport(String prefix) {
        this.knownPackagePrefixes.remove(prefix);
    }

    public List<String> getImportPrefixes() {
        return Collections.unmodifiableList(this.knownPackagePrefixes);
    }

    @Override
    public Class<?> findType(String typeName) throws EvaluationException {
        String nameToLookup = typeName;
        try {
            return ClassUtils.forName(nameToLookup, this.classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            for (String prefix : this.knownPackagePrefixes) {
                try {
                    nameToLookup = prefix + '.' + typeName;
                    return ClassUtils.forName(nameToLookup, this.classLoader);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                }
            }
            throw new SpelEvaluationException(SpelMessage.TYPE_NOT_FOUND, typeName);
        }
    }
}

