/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.jmx.export.naming;

import java.io.IOException;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.qubership.profiler.shaded.org.apache.commons.logging.Log;
import org.qubership.profiler.shaded.org.apache.commons.logging.LogFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.InitializingBean;
import org.qubership.profiler.shaded.org.springframework.core.io.Resource;
import org.qubership.profiler.shaded.org.springframework.core.io.support.PropertiesLoaderUtils;
import org.qubership.profiler.shaded.org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.qubership.profiler.shaded.org.springframework.jmx.support.ObjectNameManager;
import org.qubership.profiler.shaded.org.springframework.util.CollectionUtils;

public class KeyNamingStrategy
implements ObjectNamingStrategy,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Properties mappings;
    private Resource[] mappingLocations;
    private Properties mergedMappings;

    public void setMappings(Properties mappings) {
        this.mappings = mappings;
    }

    public void setMappingLocation(Resource location) {
        this.mappingLocations = new Resource[]{location};
    }

    public void setMappingLocations(Resource[] mappingLocations) {
        this.mappingLocations = mappingLocations;
    }

    @Override
    public void afterPropertiesSet() throws IOException {
        this.mergedMappings = new Properties();
        CollectionUtils.mergePropertiesIntoMap(this.mappings, this.mergedMappings);
        if (this.mappingLocations != null) {
            for (int i = 0; i < this.mappingLocations.length; ++i) {
                Resource location = this.mappingLocations[i];
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Loading JMX object name mappings file from " + location);
                }
                PropertiesLoaderUtils.fillProperties(this.mergedMappings, location);
            }
        }
    }

    @Override
    public ObjectName getObjectName(Object managedBean, String beanKey) throws MalformedObjectNameException {
        String objectName = null;
        if (this.mergedMappings != null) {
            objectName = this.mergedMappings.getProperty(beanKey);
        }
        if (objectName == null) {
            objectName = beanKey;
        }
        return ObjectNameManager.getInstance(objectName);
    }
}

