/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.util;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.qubership.profiler.ServerNameResolver;
import org.qubership.profiler.agent.AggregationParameterDescriptor;
import org.qubership.profiler.agent.CallInfo;
import org.qubership.profiler.agent.MetricType;
import org.qubership.profiler.agent.MetricsConfiguration;
import org.qubership.profiler.agent.MetricsDescription;
import org.qubership.profiler.agent.ProfilerData;
import org.qubership.profiler.configuration.MetricsConfigurationImpl;
import org.qubership.profiler.dump.ThreadState;
import org.qubership.profiler.metrics.AggregationParameter;
import org.qubership.profiler.metrics.MetricsPluginImpl;
import org.qubership.profiler.shaded.gnu.trove.THashSet;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;

public class MetricsCollector {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsCollector.class);
    private static BitSet matchedCalls = new BitSet();
    private static BitSet unmatchedCalls = new BitSet();
    private static Map<String, Object> params = new HashMap<String, Object>(4);
    private static Map<String, String> additionalInputParams = new HashMap<String, String>(2);

    public static void collectMetrics(MetricsPluginImpl metricsPlugin, ThreadState threadState, List<MetricsConfiguration> metricsConfiguration, long callDuration, CallInfo callInfo, ThreadState thread, String threadName) {
        try {
            if (unmatchedCalls.get(threadState.method)) {
                return;
            }
            params.put("callInfo", callInfo);
            params.put("threadState", threadState);
            params.put("duration", callDuration);
            additionalInputParams.put("java.thread", threadName);
            for (MetricsConfiguration metricConfig : metricsConfiguration) {
                if (!matchedCalls.get(threadState.method) && !MetricsCollector.checkClassMethodMatching(threadState, metricConfig) || !((MetricsConfigurationImpl)metricConfig).getFilter().evaluate(params) || metricConfig.isCustom().booleanValue()) continue;
                HashSet<AggregationParameter> aggregationParameters = new HashSet<AggregationParameter>();
                for (AggregationParameterDescriptor aggregationParameterDescriptor : metricConfig.getAggregationParameters()) {
                    aggregationParameters.add(new AggregationParameter(aggregationParameterDescriptor.getDisplayName(), "user".equals(aggregationParameterDescriptor.getName()) ? new THashSet<String>(Collections.singleton(callInfo.getNcUser())) : MetricsCollector.getThreadStateParameter(threadState, aggregationParameterDescriptor.getName())));
                }
                for (MetricsDescription metricsDescription : metricConfig.getMetrics()) {
                    MetricType metricType = MetricType.getByConfigName(metricsDescription.getName());
                    if (metricType != null) {
                        metricsPlugin.getOrCreateMetric(metricType, metricConfig.getName(), aggregationParameters, metricConfig.isCustom(), metricsDescription.getParameters(), metricConfig.getOutputVersion()).recordValue(callDuration, params);
                        continue;
                    }
                    LOG.error("No MetricType found by metric description: {}", (Object)metricsDescription.getName());
                }
            }
            if (!matchedCalls.get(threadState.method)) {
                unmatchedCalls.set(threadState.method);
            }
        }
        catch (Exception ex) {
            LOG.error("Error in collectMetrics", ex);
        }
    }

    public static void resetCaches() {
        matchedCalls.clear();
        unmatchedCalls.clear();
    }

    private static boolean checkClassMethodMatching(ThreadState threadState, MetricsConfiguration metricConfig) {
        String callName = ProfilerData.resolveMethodId(threadState.method);
        callName = callName.substring(callName.indexOf(32) + 1);
        callName = callName.substring(0, callName.indexOf(40));
        String className = callName.substring(0, callName.lastIndexOf(46));
        String methodName = callName.substring(callName.lastIndexOf(46) + 1);
        if (className.equals(metricConfig.getMatchingClass()) && ("".equals(metricConfig.getMatchingMethod()) || methodName.equals(metricConfig.getMatchingMethod()))) {
            matchedCalls.set(threadState.method);
            return true;
        }
        return false;
    }

    private static THashSet<String> getThreadStateParameter(ThreadState threadState, String parameterName) {
        THashSet<String> parameterValues = threadState.params.get(ProfilerData.resolveTag(parameterName));
        if (parameterValues == null) {
            return new THashSet<String>();
        }
        return (THashSet)parameterValues.clone();
    }

    static {
        additionalInputParams.put("node.name", String.valueOf(ServerNameResolver.SERVER_NAME));
        params.put("additionalInputParams", additionalInputParams);
    }
}

