/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.util;

public class TimeHelper {
    public static StringBuilder humanizeDifference(StringBuilder sb, long diff) {
        long diffInSeconds;
        if (diff == 0L) {
            return sb;
        }
        if (sb == null) {
            sb = new StringBuilder();
        }
        long sec = (diffInSeconds = Math.abs(diff) / 1000L) >= 60L ? diffInSeconds % 60L : diffInSeconds;
        long min = (diffInSeconds /= 60L) >= 60L ? diffInSeconds % 60L : diffInSeconds;
        long hour = (diffInSeconds /= 60L) >= 24L ? diffInSeconds % 24L : diffInSeconds;
        long day = diffInSeconds /= 24L;
        boolean started = false;
        started = TimeHelper.printTimeComponent(sb, day, " day", started);
        started = TimeHelper.printTimeComponent(sb, hour, " hour", started);
        if (!(started = TimeHelper.printTimeComponent(sb, min, " minute", started)) && sec == 0L) {
            sec = 1L;
        }
        TimeHelper.printTimeComponent(sb, sec, " second", started);
        sb.append(diff > 0L ? " ahead" : " behind");
        return sb;
    }

    private static boolean printTimeComponent(StringBuilder sb, long component, String name, boolean started) {
        if (component == 0L && !started) {
            return false;
        }
        if (started) {
            sb.append(" and");
        }
        sb.append(' ');
        sb.append(component);
        sb.append(name);
        if (component > 1L) {
            sb.append('s');
        }
        return true;
    }
}

