/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.util.cache;

import java.util.BitSet;
import org.qubership.profiler.shaded.gnu.trove.TIntObjectHashMap;

public class TLimitedIntObjectHashMap<V>
extends TIntObjectHashMap<V> {
    final int maxSize;
    final int IS_FREQUENT = Integer.MIN_VALUE;
    int clock = 0;
    BitSet frequency;

    public TLimitedIntObjectHashMap() {
        this(1000);
    }

    public TLimitedIntObjectHashMap(int maxSize) {
        this.maxSize = maxSize;
        this.frequency = new BitSet(maxSize);
        this.setAutoCompactionFactor(0.0f);
    }

    @Override
    public V get(int key) {
        int index = this.index(key);
        if (index < 0) {
            return null;
        }
        this.frequency.set(index);
        return (V)this._values[index];
    }

    @Override
    public V put(int key, V value) {
        if (this.size() >= this.maxSize) {
            this.evictStale(Math.max((int)((float)this.maxSize * 0.15f), 1));
        }
        return super.put(key, value);
    }

    private void evictStale(int killsLeft) {
        BitSet frequency = this.frequency;
        byte[] states = this._states;
        int[] set = this._set;
        int length = set.length;
        int clock = this.clock;
        while (killsLeft > 0) {
            if (states[clock] == 1) {
                if (!frequency.get(clock)) {
                    this.removeAt(clock);
                    --killsLeft;
                }
                frequency.clear(clock);
            }
            if (++clock != length) continue;
            clock = 0;
        }
        this.clock = clock;
    }
}

