/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.util.cache;

import org.qubership.profiler.shaded.gnu.trove.TLongLongHashMap;

public class TLimitedLongLongHashMap
extends TLongLongHashMap {
    final int maxSize;
    static final long IS_FREQUENT = Long.MIN_VALUE;
    int clock = 0;

    public TLimitedLongLongHashMap() {
        this(1000);
    }

    public TLimitedLongLongHashMap(int maxSize) {
        this.maxSize = maxSize;
        this.setAutoCompactionFactor(0.0f);
    }

    @Override
    public long get(long key) {
        int index = this.index(key);
        if (index < 0) {
            return -1L;
        }
        long value = this._values[index];
        this._values[index] = value | Long.MIN_VALUE;
        return value & Long.MAX_VALUE;
    }

    @Override
    public long put(long key, long value) {
        if (this.size() >= this.maxSize) {
            this.evictStale(Math.max((int)((float)this.maxSize * 0.15f), 1));
        }
        return super.put(key, value);
    }

    private void evictStale(int killsLeft) {
        long[] values = this._values;
        byte[] states = this._states;
        long[] set = this._set;
        int length = set.length;
        int clock = this.clock;
        while (killsLeft > 0) {
            if (states[clock] == 1) {
                long val = values[clock];
                if ((val & Long.MIN_VALUE) != 0L) {
                    values[clock] = val & Long.MAX_VALUE;
                } else {
                    this.removeAt(clock);
                    --killsLeft;
                }
            }
            if (++clock != length) continue;
            clock = 0;
        }
        this.clock = clock;
    }
}

