/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.qubership.profiler.CallsState;
import org.qubership.profiler.GCDumper;
import org.qubership.profiler.IDumper;
import org.qubership.profiler.ServerNameResolver;
import org.qubership.profiler.agent.BigValueHolder;
import org.qubership.profiler.agent.CallInfo;
import org.qubership.profiler.agent.DumperCollectorClient;
import org.qubership.profiler.agent.DumperConstants;
import org.qubership.profiler.agent.ESCLogger;
import org.qubership.profiler.agent.LocalBuffer;
import org.qubership.profiler.agent.LocalState;
import org.qubership.profiler.agent.MetricsConfiguration;
import org.qubership.profiler.agent.MetricsDescription;
import org.qubership.profiler.agent.ParameterInfo;
import org.qubership.profiler.agent.Profiler;
import org.qubership.profiler.agent.ProfilerAgentException;
import org.qubership.profiler.agent.ProfilerData;
import org.qubership.profiler.agent.PropertyFacadeBoot;
import org.qubership.profiler.agent.ThreadJMXProviderFactory;
import org.qubership.profiler.agent.TimerCache;
import org.qubership.profiler.client.CollectorClientFactory;
import org.qubership.profiler.dump.DataOutputStreamEx;
import org.qubership.profiler.dump.DumpFileManager;
import org.qubership.profiler.dump.IDataOutputStreamEx;
import org.qubership.profiler.dump.ThreadState;
import org.qubership.profiler.formatters.title.ProfilerTitle;
import org.qubership.profiler.formatters.title.TitleFormatterFacade;
import org.qubership.profiler.io.InflightCallImpl;
import org.qubership.profiler.io.SuspendLog;
import org.qubership.profiler.io.listener.FileRotatedListener;
import org.qubership.profiler.metrics.MetricsPluginImpl;
import org.qubership.profiler.sax.builders.InMemorySuspendLogBuilder;
import org.qubership.profiler.sax.builders.InMemorySuspendLogBuilderStub;
import org.qubership.profiler.shaded.gnu.trove.THashSet;
import org.qubership.profiler.shaded.gnu.trove.TIntIntHashMap;
import org.qubership.profiler.shaded.gnu.trove.TIntObjectIterator;
import org.qubership.profiler.shaded.gnu.trove.TIntObjectProcedure;
import org.qubership.profiler.shaded.org.apache.commons.lang.StringUtils;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;
import org.qubership.profiler.stream.CompressedLocalAndRemoteOutputStream;
import org.qubership.profiler.stream.ICompressedLocalAndRemoteOutputStream;
import org.qubership.profiler.util.DumperCallsExporter;
import org.qubership.profiler.util.MetricsCollector;
import org.qubership.profiler.util.MurmurHash;
import org.qubership.profiler.util.ThrowableHelper;
import org.qubership.profiler.util.cache.TLimitedLongLongHashMap;

public class Dumper
implements IDumper,
DumperConstants {
    private static final Logger log = LoggerFactory.getLogger(Dumper.class);
    ESCLogger escLogger = ESCLogger.getLogger(Dumper.class);
    private static final int BUFFER_STEAL_INTERVAL = Integer.getInteger(Dumper.class.getName() + ".BUFFER_STEAL_INTERVAL", 5);
    private static final int STREAM_FLUSH_INTERVAL = Integer.getInteger(Dumper.class.getName() + ".STREAM_FLUSH_INTERVAL", 5);
    private static final int BUFFER_SCALE_INTERVAL = Integer.getInteger(Dumper.class.getName() + ".BUFFER_SCALE_INTERVAL", 5);
    private static final int MAX_VALUES_PER_INDEXED_PARAM = Integer.getInteger(Dumper.class.getName() + ".MAX_VALUES_PER_INDEXED_PARAM", 100);
    public static final String DUMP_ITERATION_METHOD_NAME = "void " + Dumper.class.getName() + ".dumpIteration() (Dumper.java:200) [profiler-runtime.jar]";
    public static final int DUMP_ITERATION_METHOD_ID = ProfilerData.resolveTag(DUMP_ITERATION_METHOD_NAME) | 0x1000000;
    public static final String PROFILER_TITLE = "profiler.title";
    private DumperCallsExporter dumperCallsExporter;
    File dumpRoot;
    ICompressedLocalAndRemoteOutputStream traceOs;
    ICompressedLocalAndRemoteOutputStream callsOs;
    ICompressedLocalAndRemoteOutputStream calls_100_500_Os;
    ICompressedLocalAndRemoteOutputStream calls_500_3s_Os;
    ICompressedLocalAndRemoteOutputStream calls_3s_60m_Os;
    ICompressedLocalAndRemoteOutputStream calls_60mPlus_Os;
    ICompressedLocalAndRemoteOutputStream bigParamsOs;
    ICompressedLocalAndRemoteOutputStream bigParamsDedupOs;
    ICompressedLocalAndRemoteOutputStream dictOs;
    ICompressedLocalAndRemoteOutputStream callsDictOs;
    ICompressedLocalAndRemoteOutputStream suspendOs;
    ICompressedLocalAndRemoteOutputStream gcOs;
    ICompressedLocalAndRemoteOutputStream paramInfoOs;
    List<ICompressedLocalAndRemoteOutputStream> outputStreams;
    List<ICompressedLocalAndRemoteOutputStream> remoteStreams;
    TLimitedLongLongHashMap dedupParamCache = new TLimitedLongLongHashMap(Integer.getInteger(Dumper.class.getName() + ".SQL_CACHE_SIZE", 10000));
    long lastSuspendLogEntry = TimerCache.startTime;
    long prevSuspendDate = -1L;
    int prevSuspendDuration;
    int lastWrittenDictionaryTag;
    List<String> dictionary = ProfilerData.getTags();
    Set<Integer> callsDictionaryIds = new HashSet<Integer>();
    private final BlockingQueue<LocalBuffer> dirtyBuffers;
    private final BlockingQueue<LocalBuffer> emptyBuffers;
    private final ConcurrentMap<Thread, LocalState> buffers;
    private final String dumpRootFolder;
    private String relativeDumpRootPath;
    private TIntIntHashMap paramTypes = new TIntIntHashMap();
    private byte[] paramTypesStream;
    private boolean writeCallRanges;
    private boolean writeCallsDictionary;
    private static int PARAM_COMMON_STARTED = ProfilerData.resolveTag("common.started");
    private static int PARAM_PROFILER_TITLE = ProfilerData.resolveTag("profiler.title");
    private static int PARAM_NODE_NAME = ProfilerData.resolveTag("node.name");
    private static int PARAM_JAVA_THREAD = ProfilerData.resolveTag("java.thread");
    private static int PARAM_LOG_GENERATED = ProfilerData.resolveTag("log.generated");
    private static int PARAM_LOG_WRITTEN = ProfilerData.resolveTag("log.written");
    private static int PARAM_CPU_TIME = ProfilerData.resolveTag("time.cpu");
    private static int PARAM_WAIT_TIME = ProfilerData.resolveTag("time.wait");
    private static int PARAM_MEMORY_ALLOCATED = ProfilerData.resolveTag("memory.allocated");
    private static int PARAM_IO_DISK_READ = ProfilerData.resolveTag("io.disk.read");
    private static int PARAM_IO_DISK_WRITTEN = ProfilerData.resolveTag("io.disk.written");
    private static int PARAM_IO_NET_READ = ProfilerData.resolveTag("io.net.read");
    private static int PARAM_IO_NET_WRITTEN = ProfilerData.resolveTag("io.net.written");
    private static int PARAM_J2EE_TRANSACTIONS = ProfilerData.resolveTag("j2ee.transactions");
    private static int PARAM_QUEUE_WAIT_TIME = ProfilerData.resolveTag("time.queue.wait");
    public static final String PARAM_REMOTE_DUMP_HOST = "REMOTE_DUMP_HOST";
    public static final String PARAM_REMOTE_DUMP_PORT = "REMOTE_DUMP_PORT";
    public static final String PARAM_REMOTE_DUMP_PORT_PLAIN = "REMOTE_DUMP_PORT_PLAIN";
    public static final String PARAM_REMOTE_DUMP_PORT_SSL = "REMOTE_DUMP_PORT_SSL";
    public static final String PARAM_FORCE_LOCAL_DUMP = "FORCE_LOCAL_DUMP";
    public static final String PARAM_CLOUD_NAMESPACE = "CLOUD_NAMESPACE";
    public static final String PARAM_MICROSERVICE_NAME = "MICROSERVICE_NAME";
    int lastBufferStealTime;
    int lastStreamFlushTime;
    int lastBufferScaleTime;
    long recordsWritten = 0L;
    int nextTimeWritePerformanceInfo = TimerCache.timer + 1800;
    long nextIdleThreadWarningTime;
    long dumperStartTime = TimerCache.now;
    long dumpTime = 0L;
    int methodsWritten = 0;
    private String dumpRootPath;
    private DumpFileManager dumpFileManager;
    private long logMaxAge;
    private long lastLogPurgeTimestamp;
    private long logMaxSize;
    private long lastLogPurgeSize;
    private long compressedBytesWrittenBaseline;
    private List<MetricsConfiguration> metricsConfiguration;
    public LocalState localState;
    private MetricsPluginImpl metricsPlugin;
    private InMemorySuspendLogBuilder inMemorySuspendLogBuilder;
    private DumperCollectorClient client;
    private boolean localDumpEnabled;
    private boolean remoteConfigured;
    private GCDumper gcDumper;
    private volatile boolean initialized = false;
    String cloudNamespace = PropertyFacadeBoot.getPropertyOrEnvVariable("CLOUD_NAMESPACE");
    String microserviceName = PropertyFacadeBoot.getPropertyOrEnvVariable("MICROSERVICE_NAME");
    String podName = ServerNameResolver.SERVER_NAME + "_" + System.currentTimeMillis();
    String remoteHost = PropertyFacadeBoot.getPropertyOrEnvVariable("REMOTE_DUMP_HOST");
    String remotePortStringSSL = PropertyFacadeBoot.getPropertyOrEnvVariable("REMOTE_DUMP_PORT_SSL");
    String remotePortStringPlain = PropertyFacadeBoot.getPropertyOrEnvVariable("REMOTE_DUMP_PORT_PLAIN");
    String forceLocalDumpString = PropertyFacadeBoot.getPropertyOrEnvVariable("FORCE_LOCAL_DUMP");
    private static final List<String> LIST_WITH_EMPTY_STRING = Collections.singletonList("");

    public Dumper(BlockingQueue<LocalBuffer> dirtyBuffers, BlockingQueue<LocalBuffer> emptyBuffers, ConcurrentMap<Thread, LocalState> buffers, String dumpFolder, MetricsPluginImpl metricsPlugin) {
        this.dirtyBuffers = dirtyBuffers;
        this.emptyBuffers = emptyBuffers;
        this.buffers = buffers;
        this.dumpRootFolder = dumpFolder;
        this.metricsPlugin = metricsPlugin;
        this.dumperCallsExporter = new DumperCallsExporter();
        this.inMemorySuspendLogBuilder = ProfilerData.INMEMORY_SUSPEND_LOG ? new InMemorySuspendLogBuilder(ProfilerData.INMEMORY_SUSPEND_LOG_SIZE, ProfilerData.INMEMORY_SUSPEND_LOG_SIZE) : new InMemorySuspendLogBuilderStub();
        this.remoteConfigured = StringUtils.isNotEmpty(this.remoteHost);
        boolean forceLocalDump = StringUtils.isNotEmpty(this.forceLocalDumpString) && Boolean.parseBoolean(this.forceLocalDumpString);
        this.localDumpEnabled = forceLocalDump || !this.remoteConfigured;
        this.writeCallRanges = ProfilerData.WRITE_CALL_RANGES && this.localDumpEnabled;
        this.writeCallsDictionary = ProfilerData.WRITE_CALLS_DICTIONARY && this.localDumpEnabled;
        this.initStreams();
        log.info("Profiler dumper: Remote client connection parameters:\n{}:\t{}\n{}:\t{}\n{}:\t{}\n{}:\t{}\n{}:\t{}\n{}:\t{}\n{}:\t{}\n{}:\t{}\n{}:\t{}", PARAM_CLOUD_NAMESPACE, this.cloudNamespace, PARAM_MICROSERVICE_NAME, this.microserviceName, "pod name", this.podName, PARAM_REMOTE_DUMP_HOST, this.remoteHost, PARAM_REMOTE_DUMP_PORT_SSL, this.remotePortStringSSL, PARAM_REMOTE_DUMP_PORT_PLAIN, this.remotePortStringPlain, PARAM_FORCE_LOCAL_DUMP, this.forceLocalDumpString, "remote configured", this.remoteConfigured, "local dump enabled", this.localDumpEnabled);
    }

    private void initStreams() {
        this.traceOs = new CompressedLocalAndRemoteOutputStream("trace", (int)Integer.getInteger(Dumper.class.getName() + ".TRACE_LOG_ROTATE_SIZE", 0x6400000), 0){

            @Override
            public void fileRotated() throws IOException {
                this.getStream().writeLong(TimerCache.startTime);
            }
        };
        this.callsOs = new CallsCompressedLocalAndRemoteOutputStream("calls", (int)Integer.getInteger(Dumper.class.getName() + ".CALLS_LOG_ROTATE_SIZE", 0xA00000), 4);
        this.calls_100_500_Os = this.writeCallRanges ? new CallsCompressedLocalAndRemoteOutputStream("calls[100ms-500ms]", (int)Integer.getInteger(Dumper.class.getName() + ".CALLS_RANGE_LOG_ROTATE_SIZE", 0x100000), 4) : null;
        this.calls_500_3s_Os = this.writeCallRanges ? new CallsCompressedLocalAndRemoteOutputStream("calls[500ms-3s]", (int)Integer.getInteger(Dumper.class.getName() + ".CALLS_RANGE_LOG_ROTATE_SIZE", 0x100000), 4) : null;
        this.calls_3s_60m_Os = this.writeCallRanges ? new CallsCompressedLocalAndRemoteOutputStream("calls[3s-60m]", (int)Integer.getInteger(Dumper.class.getName() + ".CALLS_RANGE_LOG_ROTATE_SIZE", 0x100000), 4) : null;
        this.calls_60mPlus_Os = this.writeCallRanges ? new CallsCompressedLocalAndRemoteOutputStream("calls[60m+]", (int)Integer.getInteger(Dumper.class.getName() + ".CALLS_RANGE_LOG_ROTATE_SIZE", 0x100000), 4) : null;
        this.bigParamsOs = new CompressedLocalAndRemoteOutputStream("xml", Integer.getInteger(Dumper.class.getName() + ".XML_LOG_ROTATE_SIZE", 0x6400000), 0);
        this.bigParamsDedupOs = new CompressedLocalAndRemoteOutputStream("sql", (int)Integer.getInteger(Dumper.class.getName() + ".SQL_LOG_ROTATE_SIZE", 0x6400000), 0){

            @Override
            public void fileRotated() throws IOException {
                Dumper.this.dedupParamCache.clear();
            }
        };
        this.bigParamsDedupOs.setDependentStream(this.traceOs);
        this.dictOs = new CompressedLocalAndRemoteOutputStream("dictionary", 0, 0){

            @Override
            protected boolean resetExistingContents() {
                return Dumper.this.lastWrittenDictionaryTag == 0;
            }
        };
        this.callsDictOs = this.writeCallsDictionary ? new CompressedLocalAndRemoteOutputStream("callsDictionary", 0, 0) : null;
        this.suspendOs = new CompressedLocalAndRemoteOutputStream("suspend", 0, 0){

            @Override
            public void fileRotated() throws IOException {
                this.getStream().writeLong(Dumper.this.lastSuspendLogEntry);
            }
        };
        this.gcOs = new CompressedLocalAndRemoteOutputStream("gc", 0, 0);
        this.paramInfoOs = new CompressedLocalAndRemoteOutputStream("params", 0, 0){

            @Override
            public void fileRotated() throws IOException {
                this.getStream().write(Dumper.this.paramTypesStream);
                this.writePhrase();
                this.getStream().flush();
                this.close();
            }
        };
        this.outputStreams = new ArrayList<ICompressedLocalAndRemoteOutputStream>(Arrays.asList(this.traceOs, this.callsOs, this.bigParamsOs, this.bigParamsDedupOs, this.dictOs, this.suspendOs, this.gcOs, this.paramInfoOs));
        if (this.writeCallRanges) {
            this.outputStreams.addAll(Arrays.asList(this.calls_100_500_Os, this.calls_500_3s_Os, this.calls_3s_60m_Os, this.calls_60mPlus_Os));
        }
        if (this.writeCallsDictionary) {
            this.outputStreams.add(this.callsDictOs);
        }
        this.remoteStreams = Arrays.asList(this.traceOs, this.callsOs, this.bigParamsOs, this.bigParamsDedupOs, this.dictOs, this.suspendOs, this.gcOs, this.paramInfoOs);
    }

    private void initializeCollectorClient() {
        boolean ssl;
        for (ICompressedLocalAndRemoteOutputStream stream : this.outputStreams) {
            stream.setLocalDumpEnabled(this.localDumpEnabled);
        }
        String remotePortString = this.remotePortStringSSL;
        boolean bl = ssl = !StringUtils.isBlank(remotePortString);
        if (!ssl) {
            remotePortString = this.remotePortStringPlain;
        }
        if (this.remoteConfigured) {
            int remotePort = 1715;
            try {
                if (!StringUtils.isBlank(remotePortString)) {
                    remotePort = Integer.parseInt(remotePortString);
                }
            }
            catch (NumberFormatException e) {
                log.debug("Failed to parse remote dump port, use default port {}", (Object)remotePort);
            }
            this.client = CollectorClientFactory.instance().newClient(this.remoteHost, remotePort, ssl, this.cloudNamespace, this.microserviceName, this.podName);
            for (ICompressedLocalAndRemoteOutputStream stream : this.remoteStreams) {
                stream.setClient(this.client);
            }
        }
    }

    public void configure(Map<String, ParameterInfo> paramInfo, long logMaxAge, long logMaxSize, List<MetricsConfiguration> metrics, List<MetricsDescription> systemMetrics) {
        if (this.logMaxAge != logMaxAge || this.logMaxSize != logMaxSize) {
            this.lastLogPurgeTimestamp = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L) - logMaxAge * 2L;
        }
        this.logMaxAge = logMaxAge;
        this.logMaxSize = logMaxSize;
        this.metricsConfiguration = metrics;
        if (paramInfo == null) {
            return;
        }
        TIntIntHashMap paramTypes = new TIntIntHashMap();
        ArrayList<ParameterInfo> listParams = new ArrayList<ParameterInfo>();
        for (ParameterInfo info : paramInfo.values()) {
            paramTypes.put(ProfilerData.resolveTag(info.name), info.combined);
            if (!info.list) continue;
            listParams.add(info);
        }
        this.paramTypes = paramTypes;
        this.paramTypesStream = this.prepareParamInfoStream(paramInfo);
        TitleFormatterFacade.setDefaultListParams(listParams);
        this.metricsPlugin.resetMetrics();
        MetricsCollector.resetCaches();
        this.metricsPlugin.createSystemMetrics(systemMetrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] prepareParamInfoStream(Map<String, ParameterInfo> paramInfo) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(paramInfo.size() * 40);
        DataOutputStreamEx out = new DataOutputStreamEx(baos);
        try {
            out.write(1);
            for (ParameterInfo info : paramInfo.values()) {
                out.write(info.name);
                out.write(info.index ? 1 : 0);
                out.write(info.list ? 1 : 0);
                out.writeVarInt(info.order);
                out.write(info.signatureFunction == null ? "" : info.signatureFunction);
            }
            Object object = baos.toByteArray();
            return object;
        }
        catch (IOException e) {
            log.warn("Unable to write parameter types", e);
        }
        finally {
            this.close(out);
        }
        return null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public synchronized void close() throws IOException {
        this.initialized = false;
        int outputStreamsSize = this.outputStreams.size();
        for (int i = 0; i < outputStreamsSize; ++i) {
            ICompressedLocalAndRemoteOutputStream stream = this.outputStreams.get(i);
            this.close(stream);
        }
        if (this.dumpFileManager != null) {
            this.dumpFileManager.close();
            this.dumpFileManager = null;
        }
        if (this.gcDumper != null) {
            this.gcDumper.close();
            this.gcDumper = null;
        }
        log.debug("Closed ESC dump files");
        if (this.client != null) {
            try {
                this.client.close();
                this.client = null;
                log.debug("RPC client has been shut down");
            }
            catch (IOException e) {
                log.error("Failed to wait till graceful shutdown of remote RPC connection, skip it.", e);
            }
        }
    }

    @Override
    public void initialize() throws IOException {
        Profiler.markSystem();
        this.dedupParamCache.clear();
        ProfilerData.clearThreadsInfo();
        this.lastWrittenDictionaryTag = 0;
        this.lastBufferStealTime = TimerCache.timer;
        this.lastBufferScaleTime = TimerCache.timer;
        this.lastStreamFlushTime = TimerCache.timer;
        this.nextTimeWritePerformanceInfo = TimerCache.timer + 1800;
        this.dumperStartTime = TimerCache.now;
        this.dumpTime = 0L;
        this.recordsWritten = 0L;
        LocalState state = Profiler.getState();
        ThreadJMXProviderFactory.INSTANCE.updateThreadCounters(state);
        ThreadState ts = new ThreadState();
        state.additional = ts;
        ts.saveThreadCounters(state.callInfo);
        this.localState = state;
        Date date = new Date();
        this.dumpRootPath = this.dumpRootFolder + File.separatorChar + new SimpleDateFormat("yyyy'" + File.separatorChar + "'MM'" + File.separatorChar + "'dd").format(date) + File.separatorChar + date.getTime();
        this.dumpRoot = new File(this.dumpRootPath);
        this.relativeDumpRootPath = this.calculateRelativeDumpRootFolder(this.dumpRootPath);
        long compressedBytes = 0L;
        if (this.dumpFileManager != null) {
            this.dumpFileManager.close();
        }
        DumpFileManager fm = this.dumpFileManager = new DumpFileManager(this.logMaxAge, this.logMaxSize, this.dumpRootFolder);
        FileRotatedListener listener = fm.getFileRotatedListener();
        this.initializeCollectorClient();
        this.gcDumper = new GCDumper(this.gcOs);
        int outputStreamsSize = this.outputStreams.size();
        for (int i = 0; i < outputStreamsSize; ++i) {
            ICompressedLocalAndRemoteOutputStream stream = this.outputStreams.get(i);
            stream.setRoot(this.dumpRoot);
            stream.clearListeners();
            stream.addListener(listener);
            stream.rotate();
            compressedBytes += stream.getCompressedSize();
        }
        this.compressedBytesWrittenBaseline = compressedBytes;
        this.initialized = true;
    }

    private String calculateRelativeDumpRootFolder(String dumpRootPath) {
        Path p = Paths.get(dumpRootPath, new String[0]);
        return p.subpath(p.getNameCount() - 5, p.getNameCount()).toString();
    }

    public void addEmptyBuffer(LocalBuffer buffer) {
        this.emptyBuffers.offer(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpLoop() throws InterruptedException, IOException {
        log.info("Profiler dumper initialized successfully. Data will be collected at least every {} sec. Data will be sent at least every {} sec", (Object)BUFFER_STEAL_INTERVAL, (Object)STREAM_FLUSH_INTERVAL);
        ArrayList<LocalBuffer> buffers = new ArrayList<LocalBuffer>();
        while (this.dirtyBuffers != null) {
            LocalBuffer firstBuffer;
            buffers.clear();
            this.escLogger.printDirtyBufferWarningInCaseOfOverflow();
            if (this.dirtyBuffers.drainTo(buffers, 100) == 0 && (firstBuffer = this.dirtyBuffers.poll(BUFFER_STEAL_INTERVAL, TimeUnit.SECONDS)) != null) {
                buffers.add(firstBuffer);
            }
            this.localState.enter(DUMP_ITERATION_METHOD_ID);
            try {
                int dirtyLength = buffers.size();
                long t0 = System.nanoTime();
                for (int i = 0; i < dirtyLength; ++i) {
                    LocalBuffer buffer = (LocalBuffer)buffers.get(i);
                    if (buffer.corrupted) {
                        log.error("Corrupted buffer is in dirtyBuffers queue {}", (Object)buffer);
                        continue;
                    }
                    if (buffer.state == null) {
                        log.error("Buffer {} (prevBuffer=={}) with null state is found in dirtyBuffers queue.", (Object)buffer, (Object)buffer.prevBuffer);
                        continue;
                    }
                    if (buffer.count == -1) {
                        switch ((int)buffer.data[0]) {
                            case 1: {
                                this.rotateDumpFile();
                                break;
                            }
                            case 2: {
                                this.flushDumpFile();
                                break;
                            }
                            case 3: {
                                this.close();
                                return;
                            }
                            case 5: {
                                Object result;
                                this.stealDataFromBuffers();
                                if (TimerCache.lastLoggedEvent != TimerCache.lastSuspendEvent) {
                                    this.dumpSuspendLog();
                                }
                                if (this.lastWrittenDictionaryTag < this.dictionary.size()) {
                                    this.dumpDictionary();
                                }
                                this.gcDumper.dumpGC();
                                this.flushDumpFile();
                                this.close();
                                Object object = result = buffer.value[0];
                                synchronized (object) {
                                    Object[] res = (Object[])result;
                                    res[0] = "DONE";
                                    result.notify();
                                }
                                buffer.value[0] = null;
                                return;
                            }
                            case 4: {
                                this.flushDumpFile();
                                this.collectInflightCalls(buffer.value[0]);
                                buffer.value[0] = null;
                            }
                        }
                        this.cleanupBuffer(buffer);
                        buffer.count = 0;
                        this.addEmptyBuffer(buffer);
                        continue;
                    }
                    if (buffer.count > buffer.first) {
                        this.recordsWritten += (long)this.writeBuffer(buffer);
                    }
                    this.cleanupBuffer(buffer);
                    this.addEmptyBuffer(buffer);
                }
                if (TimerCache.lastLoggedEvent != TimerCache.lastSuspendEvent) {
                    this.dumpSuspendLog();
                }
                this.gcDumper.dumpGC();
                long t1 = System.nanoTime();
                long t2 = System.nanoTime();
                this.dumpTime += t1 - t0 - (t2 - t1);
                boolean fileRotated = false;
                boolean isTraceRotated = false;
                boolean isCallsRotated = false;
                int outputStreamsSize = this.outputStreams.size();
                for (int i = 0; i < outputStreamsSize; ++i) {
                    ICompressedLocalAndRemoteOutputStream stream = this.outputStreams.get(i);
                    boolean rotated = stream.rotateIfRequired();
                    if ("trace".equals(stream.getName())) {
                        isTraceRotated = rotated;
                    }
                    if ("calls".equals(stream.getName())) {
                        isCallsRotated = rotated;
                    }
                    fileRotated |= rotated;
                }
                if (this.recordsWritten > 0L && this.nextTimeWritePerformanceInfo - TimerCache.timer < 0) {
                    long compressedSize = this.getCompressedSize();
                    long uncompressedSize = this.getUncompressedSize();
                    log.debug("Processed {} records, average rate is rate = {} ns/record, written {} MiB total (uncompressed size is {} MiB, compression rate {}), {} MiB is written since last restart of dumper . Written {} bytes since last purge (will purge when reach {} bytes or {})", this.recordsWritten, (double)this.dumpTime / ((double)this.recordsWritten + 0.001), compressedSize / 1024L / 1024L, uncompressedSize / 1024L / 1024L, (double)uncompressedSize / ((double)compressedSize + 0.001), (compressedSize - this.compressedBytesWrittenBaseline) / 1024L / 1024L, compressedSize - this.lastLogPurgeSize, this.logMaxSize * 2L, new Date(this.lastLogPurgeTimestamp + this.logMaxAge * 2L));
                    this.nextTimeWritePerformanceInfo = TimerCache.timer + 30000;
                }
                if ((long)(TimerCache.timer - this.lastBufferStealTime) > TimeUnit.SECONDS.toMillis(BUFFER_STEAL_INTERVAL)) {
                    this.stealDataFromBuffers();
                }
                if ((long)(TimerCache.timer - this.lastBufferScaleTime) > TimeUnit.SECONDS.toMillis(BUFFER_SCALE_INTERVAL)) {
                    this.scaleBuffers();
                }
                if (this.lastWrittenDictionaryTag < this.dictionary.size()) {
                    this.dumpDictionary();
                }
                if ((long)(TimerCache.timer - this.lastStreamFlushTime) <= TimeUnit.SECONDS.toMillis(STREAM_FLUSH_INTERVAL)) continue;
                this.flushDumpFile();
            }
            finally {
                this.localState.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectInflightCalls(Object result) {
        ArrayList<InflightCallImpl> calls = new ArrayList<InflightCallImpl>();
        long nowLong = TimerCache.now;
        int now = (int)(nowLong - TimerCache.startTime);
        for (LocalState state : this.buffers.values()) {
            if (!(state.additional instanceof ThreadState)) continue;
            ThreadState ts = (ThreadState)state.additional;
            if (ts.method == 0) continue;
            CallInfo callInfo = ts.callInfo;
            if (callInfo == null) {
                log.info("Detected active thread {}, however unable to identify what it is doing, since callInfo is null. Thread state: {}", (Object)state.shortThreadName, (Object)ts);
                continue;
            }
            InflightCallImpl call = new InflightCallImpl();
            call.time = nowLong - (long)(now - ts.time);
            call.method = ts.method;
            call.calls = ts.calls;
            call.traceFileIndex = ts.traceFileIndex;
            call.bufferOffset = ts.bufferOffset;
            call.recordIndex = ts.recordIndex;
            call.threadName = state.thread.getName();
            call.queueWaitDuration = callInfo.queueWaitDuration;
            call.logsGenerated = callInfo.logGenerated;
            call.logsWritten = callInfo.logWritten;
            call.params = new HashMap<Integer, List<String>>(ts.params.size() + 1, 1.0f);
            final HashMap<Integer, List<String>> params = call.params;
            params.put(-4, LIST_WITH_EMPTY_STRING);
            if (callInfo.next == null) {
                call.duration = now - ts.time;
                ThreadJMXProviderFactory.INSTANCE.updateThreadCounters(state);
                call.cpuTime = state.cpuTime - ts.prevCpuTime;
                call.waitTime = state.waitTime - ts.prevWaitTime;
                call.memoryUsed = state.memoryUsed - ts.prevMemoryUsed;
                call.fileRead = state.fileRead - ts.prevFileRead;
                call.fileWritten = state.fileWritten - ts.prevFileWritten;
                call.netRead = state.netRead - ts.prevNetRead;
                call.netWritten = state.netWritten - ts.prevNetWritten;
                call.transactions = state.transactions - ts.prevTransactions;
            } else {
                call.duration = callInfo.finishTime - ts.time;
                call.cpuTime = callInfo.cpuTime - ts.prevCpuTime;
                call.waitTime = callInfo.waitTime - ts.prevWaitTime;
                call.memoryUsed = callInfo.memoryUsed - ts.prevMemoryUsed;
                call.fileRead = callInfo.fileRead - ts.prevFileRead;
                call.fileWritten = callInfo.fileWritten - ts.prevFileWritten;
                call.netRead = callInfo.netRead - ts.prevNetRead;
                call.netWritten = callInfo.netWritten - ts.prevNetWritten;
                call.transactions = callInfo.transactions - ts.prevTransactions;
            }
            if (!ts.params.isEmpty()) {
                ts.params.forEachEntry(new TIntObjectProcedure<THashSet<String>>(){

                    @Override
                    public boolean execute(int i, THashSet<String> strings) {
                        params.put(i, Arrays.asList(strings.toArray(new String[strings.size()])));
                        return true;
                    }
                });
                ProfilerTitle title = TitleFormatterFacade.formatTitle(call.method, ts.params);
                params.put(PARAM_PROFILER_TITLE, Collections.singletonList(title.getHtml()));
            }
            calls.add(call);
        }
        Object object = result;
        synchronized (object) {
            Object[] res = (Object[])result;
            res[0] = this.dumpRoot;
            res[1] = calls;
            result.notify();
        }
    }

    private void scaleBuffers() {
        int activeThreads;
        int dirtyBuffers;
        int emptyBuffers;
        int addedCount = 0;
        for (int i = 0; i < ProfilerData.MAX_SCALE_ATTEMPTS && (emptyBuffers = this.emptyBuffers.size()) + (dirtyBuffers = this.dirtyBuffers.size()) < Math.max(ProfilerData.MIN_BUFFERS, activeThreads = this.buffers.size()); ++i) {
            boolean added = this.emptyBuffers.offer(new LocalBuffer());
            if (added) {
                ++addedCount;
                continue;
            }
            log.debug("Unable to add new empty buffer. emptyBuffers.size(): {}, dirtyBuffers.size(): {}, buffers.size(): {}, ProfilerData.MIN_BUFFERS: {}, addedCount: {}", emptyBuffers, dirtyBuffers, activeThreads, ProfilerData.MIN_BUFFERS, addedCount);
            return;
        }
        if (addedCount > 0) {
            log.debug("Added {} buffers for ensuring (empty+dirty).size >= MIN_BUFFERS. emptyBuffers.size(): {}, dirtyBuffers.size(): {}, buffers.size(): {}, ProfilerData.MIN_BUFFERS: {}", addedCount, this.emptyBuffers.size(), this.dirtyBuffers.size(), this.buffers.size(), ProfilerData.MIN_BUFFERS);
        }
        this.lastBufferScaleTime = TimerCache.timer;
    }

    private void stealDataFromBuffers() throws IOException, InterruptedException {
        long latestTimeToSteal = TimerCache.now - TimeUnit.SECONDS.toMillis(BUFFER_STEAL_INTERVAL);
        long nextWarningTime = TimerCache.now + TimeUnit.SECONDS.toMillis(3600L);
        boolean idleThreadsDetected = false;
        for (LocalState state : this.buffers.values()) {
            LocalBuffer buffer = state.buffer;
            if (buffer.corrupted || buffer == null || buffer.count == -1 || buffer.startTime > latestTimeToSteal || buffer.prevBuffer != null && buffer.prevBuffer.state == state || state.isSystem) continue;
            boolean threadIsAlive = state.thread.isAlive();
            if (!threadIsAlive) {
                if (this.buffers.remove(state.thread) == null) {
                    log.debug("Thread {} info was already collected", (Object)state.thread.getName());
                    continue;
                }
                log.info("Detected dead thread {} during buffer steal", (Object)state.thread.getName());
                this.writeBuffer(buffer);
                continue;
            }
            if (buffer.count == buffer.first) {
                if (this.nextIdleThreadWarningTime >= buffer.startTime) continue;
                log.trace("Detected thread {} that is still alive, while it did not produce any profiled events since {}", (Object)state.thread.getName(), (Object)new Date(buffer.startTime));
                idleThreadsDetected = true;
                continue;
            }
            this.writeBuffer(buffer);
        }
        this.lastBufferStealTime = TimerCache.timer;
        if (idleThreadsDetected) {
            this.nextIdleThreadWarningTime = nextWarningTime;
        }
    }

    private int writeBuffer(LocalBuffer buffer) throws IOException {
        log.trace("Write trace buffer started at {}", (Object)buffer.startTime);
        return this.writeBufferToFS(buffer);
    }

    private int writeBufferToFS(LocalBuffer buffer) throws IOException {
        int count;
        LocalState state = buffer.state;
        Object additional = state.additional;
        ThreadState thread = null;
        if (additional instanceof ThreadState) {
            thread = (ThreadState)additional;
        }
        int last = buffer.count;
        int offs = buffer.first;
        if (thread == null) {
            CallInfo callInfo = null;
            if (state.dumperIncarnation != ProfilerData.dumperIncarnation) {
                int i;
                long[] data = buffer.data;
                for (i = offs; i < last; ++i) {
                    int typeAndId = (int)data[i];
                    if (typeAndId != ProfilerData.PARAM_CALL_INFO) continue;
                    callInfo = (CallInfo)buffer.value[i];
                    break;
                }
                if (callInfo == null) {
                    long startOffset = data[last - 1] >>> 32;
                    buffer.first = i;
                    buffer.startTime += (startOffset -= data[buffer.first] >>> 32);
                    return 0;
                }
                buffer.first = offs = i + 1;
            }
            thread = new ThreadState();
            if (callInfo != null) {
                thread.saveThreadCounters(callInfo);
            } else {
                callInfo = state.callInfo;
                if (callInfo.isFirstInThread) {
                    thread.callInfo = callInfo;
                }
            }
            state.additional = thread;
        }
        if ((count = last - offs) == 0) {
            return 0;
        }
        int prevMillis = 0;
        IDataOutputStreamEx traceOs = this.traceOs.getStream();
        int bufferOffset = traceOs.size();
        traceOs.writeLong(buffer.state.thread.getId());
        traceOs.writeLong(buffer.startTime);
        long[] data = buffer.data;
        Object[] values = buffer.value;
        for (int i = offs; i < last; ++i) {
            String value;
            long item = data[i];
            int typeAndId = (int)item;
            int type = typeAndId >>> 24;
            if (type == 3 && values[i] == null) {
                ++offs;
                continue;
            }
            int curMillis = (int)(item >>> 32);
            int millis = curMillis - prevMillis;
            prevMillis = curMillis;
            int b = type ^ 1 | (millis & 0x1F) << 2;
            if (millis <= 31 && millis >= 0) {
                traceOs.write(b);
            } else {
                traceOs.write(b | 0x80);
                traceOs.writeVarInt(millis >> 5);
            }
            if (typeAndId == 0) continue;
            int id = typeAndId & 0xFFFFFF;
            if (type == 1) {
                traceOs.writeVarInt(id);
                if (thread.method == 0) {
                    thread.time = curMillis;
                    thread.calls = 0;
                    thread.method = id;
                    thread.traceFileIndex = this.traceOs.getIndex();
                    thread.bufferOffset = bufferOffset;
                    thread.recordIndex = i - offs;
                }
                ++thread.calls;
                continue;
            }
            Object o = values[i];
            values[i] = null;
            if (o == null) {
                throw new ProfilerAgentException("Looks like there is a corruption in buffer contents for buffer " + buffer + ", index " + i + ", thread " + state.thread);
            }
            if (o instanceof String) {
                value = (String)o;
            } else if (o instanceof StringBuffer || o instanceof StringBuilder || o instanceof Number) {
                value = o.toString();
            } else if (o instanceof Throwable) {
                value = ThrowableHelper.throwableToString((Throwable)o);
            } else {
                if (o instanceof CallInfo) {
                    CallInfo callInfo = (CallInfo)o;
                    ProfilerTitle profilerTitle = TitleFormatterFacade.formatTitle(thread.method, thread.params);
                    long callDuration = curMillis - thread.time + callInfo.additionalReportedTime;
                    MetricsCollector.collectMetrics(this.metricsPlugin, thread, this.metricsConfiguration, callDuration, callInfo, thread, buffer.state.thread.getName());
                    this.writeParam(thread, id, "");
                    if (thread.calls > 1 || callDuration > 20L || callInfo.isPersist > 0) {
                        long startTimestamp = buffer.startTime + (long)(thread.time - (int)(buffer.startTime - TimerCache.startTime));
                        if (this.dumperCallsExporter.isEnabled()) {
                            int suspension = this.getSuspension(startTimestamp, startTimestamp + callDuration);
                            this.dumperCallsExporter.exportCall(startTimestamp, callDuration, suspension, callInfo, profilerTitle, thread, buffer.state.thread.getName(), this.relativeDumpRootPath);
                        }
                        traceOs.write(2);
                        this.writeParam(thread, PARAM_COMMON_STARTED, Long.toString(startTimestamp));
                        --offs;
                        if (!profilerTitle.isDefault()) {
                            traceOs.write(2);
                            this.writeParam(thread, PARAM_PROFILER_TITLE, profilerTitle.getHtml());
                            --offs;
                        }
                        traceOs.write(2);
                        this.writeParam(thread, PARAM_NODE_NAME, ServerNameResolver.SERVER_NAME);
                        --offs;
                        traceOs.write(2);
                        this.writeParam(thread, PARAM_JAVA_THREAD, buffer.state.thread.getName());
                        --offs;
                        offs = this.writeCallParams(traceOs, thread, callInfo, offs);
                        this.writeCall(callInfo, thread, callDuration, state.thread);
                    }
                    traceOs.write(1);
                    --offs;
                    thread.params.clear();
                    thread.method = 0;
                    thread.saveThreadCounters(callInfo);
                    callInfo.clean();
                    continue;
                }
                if (o instanceof BigValueHolder) {
                    BigValueHolder h = (BigValueHolder)o;
                    Object val = h.getValue();
                    if (h.getIndex() != -1) {
                        traceOs.writeVarInt(id);
                        int paramType = this.paramTypes.get(id);
                        traceOs.write(paramType);
                        traceOs.writeVarInt(h.getIndex());
                        traceOs.writeVarInt(h.getOffset());
                        continue;
                    }
                    value = val.toString();
                } else {
                    value = "Object " + o.toString();
                }
            }
            this.writeParam(thread, id, value, o instanceof BigValueHolder ? (BigValueHolder)o : null);
            value = null;
        }
        traceOs.write(3);
        long startOffset = data[last - 1] >>> 32;
        buffer.startTime += (startOffset -= data[buffer.first] >>> 32);
        buffer.first = last;
        return count;
    }

    private int getSuspension(long begin, long end) {
        SuspendLog suspendLog = this.inMemorySuspendLogBuilder.get();
        return suspendLog.getSuspendDuration(begin, end);
    }

    private void writeCall(CallInfo callInfo, ThreadState threadState, long callDuration, Thread thread) throws IOException {
        this.writeCall(callInfo, threadState, callDuration, thread, this.callsOs);
        if (!this.writeCallRanges) {
            return;
        }
        if (callDuration >= 100L) {
            if (callDuration < 500L) {
                this.writeCall(callInfo, threadState, callDuration, thread, this.calls_100_500_Os);
            } else if (callDuration < 3000L) {
                this.writeCall(callInfo, threadState, callDuration, thread, this.calls_500_3s_Os);
            } else if (callDuration < 3600000L) {
                this.writeCall(callInfo, threadState, callDuration, thread, this.calls_3s_60m_Os);
            } else {
                this.writeCall(callInfo, threadState, callDuration, thread, this.calls_60mPlus_Os);
            }
        }
    }

    private void writeCall(CallInfo callInfo, ThreadState threadState, long callDuration, Thread thread, ICompressedLocalAndRemoteOutputStream callsStream) throws IOException {
        IDataOutputStreamEx callsOs = callsStream.getStream();
        CallsState callsState = (CallsState)callsStream.getState();
        callsOs.writeVarIntZigZag(threadState.time - callsState.callsTimer);
        callsState.callsTimer = threadState.time;
        callsOs.writeVarInt(threadState.method);
        this.writeCallsDictionary(threadState.method);
        callsOs.writeVarInt(callDuration);
        callsOs.writeVarInt(threadState.calls);
        int threadIndex = callsState.threadIdsCache.get(thread.getId());
        if (threadIndex >= 0) {
            callsOs.writeVarInt(threadIndex);
        } else {
            threadIndex = callsState.threadIdsCounter;
            callsState.threadIdsCounter = threadIndex + 1;
            callsState.threadIdsCache.put(thread.getId(), threadIndex);
            callsOs.writeVarInt(threadIndex);
            callsOs.write(thread.getName());
        }
        callsOs.writeVarInt(callInfo.logWritten);
        callsOs.writeVarInt(callInfo.logGenerated - callInfo.logWritten);
        callsOs.writeVarInt(threadState.traceFileIndex);
        callsOs.writeVarInt(threadState.bufferOffset);
        callsOs.writeVarInt(threadState.recordIndex);
        callsOs.writeVarInt((int)(callInfo.cpuTime - threadState.prevCpuTime));
        callsOs.writeVarInt((int)(callInfo.waitTime - threadState.prevWaitTime));
        callsOs.writeVarInt(callInfo.memoryUsed - threadState.prevMemoryUsed);
        callsOs.writeVarInt(callInfo.fileRead - threadState.prevFileRead);
        callsOs.writeVarInt(callInfo.fileWritten - threadState.prevFileWritten);
        callsOs.writeVarInt(callInfo.netRead - threadState.prevNetRead);
        callsOs.writeVarInt(callInfo.netWritten - threadState.prevNetWritten);
        callsOs.writeVarInt(callInfo.transactions - threadState.prevTransactions);
        callsOs.writeVarInt(callInfo.queueWaitDuration);
        callsOs.writeVarInt(threadState.params.size());
        TIntObjectIterator<THashSet<String>> iterator = threadState.params.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            int id = iterator.key();
            THashSet<String> set = iterator.value();
            callsOs.writeVarInt(id);
            this.writeCallsDictionary(id);
            int size = set.size();
            callsOs.writeVarInt(size);
            for (String value : set) {
                callsOs.write(value);
            }
        }
    }

    private void writeCallsDictionary(int idx) throws IOException {
        if (!this.writeCallsDictionary) {
            return;
        }
        if (!this.callsDictionaryIds.contains(idx)) {
            this.callsDictionaryIds.add(idx);
            IDataOutputStreamEx stream = this.callsDictOs.getStream();
            stream.writeVarInt(idx);
            stream.write(this.dictionary.get(idx));
        }
    }

    private int writeCallParams(IDataOutputStreamEx traceOs, ThreadState thread, CallInfo callInfo, int offs) throws IOException {
        long tmp;
        if (callInfo.logGenerated > 0) {
            traceOs.write(2);
            this.writeParam(thread, PARAM_LOG_GENERATED, Integer.toString(callInfo.logGenerated));
            --offs;
            if (callInfo.logWritten > 0) {
                traceOs.write(2);
                this.writeParam(thread, PARAM_LOG_WRITTEN, Integer.toString(callInfo.logWritten));
                --offs;
            }
        }
        if ((tmp = callInfo.cpuTime - thread.prevCpuTime) != 0L) {
            traceOs.write(2);
            this.writeParam(thread, PARAM_CPU_TIME, Long.toString(tmp));
            --offs;
        }
        if ((tmp = callInfo.waitTime - thread.prevWaitTime) != 0L) {
            traceOs.write(2);
            this.writeParam(thread, PARAM_WAIT_TIME, Long.toString(tmp));
            --offs;
        }
        if ((tmp = callInfo.memoryUsed - thread.prevMemoryUsed) != 0L) {
            traceOs.write(2);
            this.writeParam(thread, PARAM_MEMORY_ALLOCATED, Long.toString(tmp));
            --offs;
        }
        if ((tmp = callInfo.fileRead - thread.prevFileRead) != 0L) {
            traceOs.write(2);
            this.writeParam(thread, PARAM_IO_DISK_READ, Long.toString(tmp));
            --offs;
        }
        if ((tmp = callInfo.fileWritten - thread.prevFileWritten) != 0L) {
            traceOs.write(2);
            this.writeParam(thread, PARAM_IO_DISK_WRITTEN, Long.toString(tmp));
            --offs;
        }
        if ((tmp = callInfo.netRead - thread.prevNetRead) != 0L) {
            traceOs.write(2);
            this.writeParam(thread, PARAM_IO_NET_READ, Long.toString(tmp));
            --offs;
        }
        if ((tmp = callInfo.netWritten - thread.prevNetWritten) != 0L) {
            traceOs.write(2);
            this.writeParam(thread, PARAM_IO_NET_WRITTEN, Long.toString(tmp));
            --offs;
        }
        if ((tmp = callInfo.transactions - thread.prevTransactions) != 0L) {
            traceOs.write(2);
            this.writeParam(thread, PARAM_J2EE_TRANSACTIONS, Long.toString(tmp));
            --offs;
        }
        if (callInfo.queueWaitDuration != 0) {
            traceOs.write(2);
            this.writeParam(thread, PARAM_QUEUE_WAIT_TIME, Integer.toString(callInfo.queueWaitDuration));
            --offs;
        }
        return offs;
    }

    private void writeParam(ThreadState thread, int id, String value) throws IOException {
        this.writeParam(thread, id, value, null);
    }

    private void writeParam(ThreadState thread, int id, String value, BigValueHolder valueHolder) throws IOException {
        IDataOutputStreamEx traceOs = this.traceOs.getStream();
        traceOs.writeVarInt(id);
        int paramType = this.paramTypes.get(id);
        traceOs.write(paramType);
        switch (paramType) {
            case 2: {
                if (id != PARAM_JAVA_THREAD) {
                    THashSet<String> values = thread.params.get(id);
                    if (values == null) {
                        values = new THashSet();
                        thread.params.put(id, values);
                    }
                    if (values.size() < MAX_VALUES_PER_INDEXED_PARAM) {
                        values.add(value);
                    }
                }
            }
            case 0: {
                traceOs.write(value);
                break;
            }
            case 3: {
                long hash = MurmurHash.hash64(value);
                long cached = this.dedupParamCache.get(hash);
                if (cached == -1L) {
                    int offs = this.bigParamsDedupOs.getStream().write(value);
                    traceOs.writeVarInt(this.bigParamsDedupOs.getIndex());
                    traceOs.writeVarInt(offs);
                    if (valueHolder != null) {
                        valueHolder.setAddress(this.bigParamsDedupOs.getIndex(), offs);
                    }
                    this.dedupParamCache.put(hash, (long)this.bigParamsDedupOs.getIndex() << 32 | (long)offs);
                    break;
                }
                traceOs.writeVarInt((int)(cached >> 32));
                traceOs.writeVarInt((int)cached);
                if (valueHolder == null) break;
                valueHolder.setAddress((int)(cached >> 32), (int)cached);
                break;
            }
            case 1: {
                if (value.length() > 10240) {
                    log.warn("Parameter larger than 10 KB is being recorded. Param id is {}. Param size is {}. First 1kb is {}", id, value.length(), value.substring(0, 1096));
                }
                int offset = this.bigParamsOs.getStream().write(value);
                traceOs.writeVarInt(this.bigParamsOs.getIndex());
                traceOs.writeVarInt(offset);
                if (valueHolder == null) break;
                valueHolder.setAddress(this.bigParamsOs.getIndex(), offset);
            }
        }
    }

    private void cleanupBuffer(LocalBuffer buffer) {
        buffer.state = null;
        buffer.reset();
    }

    public void dumpDictionary() throws IOException {
        List<String> tags = this.dictionary;
        int size = tags.size();
        IDataOutputStreamEx dictOs = this.dictOs.getStream();
        for (int i = this.lastWrittenDictionaryTag; i < size; ++i) {
            dictOs.write(tags.get(i));
            this.dictOs.writePhrase();
        }
        this.lastWrittenDictionaryTag = size;
    }

    public void dumpSuspendLog() throws IOException {
        int i = TimerCache.lastLoggedEvent;
        long[] dates = TimerCache.suspendDates;
        int[] durations = TimerCache.suspendDurations;
        IDataOutputStreamEx suspendOs = this.suspendOs.getStream();
        long prevTime = this.lastSuspendLogEntry;
        while (i != TimerCache.lastSuspendEvent) {
            long time = dates[i];
            int duration = durations[i];
            if (this.prevSuspendDate == time - (long)duration) {
                this.prevSuspendDate = time;
                this.prevSuspendDuration += duration;
                this.inMemorySuspendLogBuilder.visitNotFinishedHiccup(this.prevSuspendDate, this.prevSuspendDuration);
            } else {
                if (this.prevSuspendDate != -1L) {
                    this.inMemorySuspendLogBuilder.visitFinishedHiccup(this.prevSuspendDate, this.prevSuspendDuration);
                    suspendOs.writeVarInt((int)(this.prevSuspendDate - prevTime));
                    suspendOs.writeVarInt(this.prevSuspendDuration);
                    prevTime = this.prevSuspendDate;
                    this.suspendOs.writePhrase();
                }
                this.prevSuspendDate = time;
                this.prevSuspendDuration = duration;
            }
            i = i == TimerCache.SUSPEND_LOG_SIZE ? 0 : i + 1;
        }
        TimerCache.lastLoggedEvent = i;
        this.lastSuspendLogEntry = prevTime;
    }

    private void rotateDumpFile() throws IOException {
        int outputStreamsSize = this.outputStreams.size();
        for (int i = 0; i < outputStreamsSize; ++i) {
            ICompressedLocalAndRemoteOutputStream stream = this.outputStreams.get(i);
            stream.rotate();
        }
    }

    private void flushDumpFile() throws IOException {
        int outputStreamsSize = this.outputStreams.size();
        for (int i = 0; i < outputStreamsSize; ++i) {
            ICompressedLocalAndRemoteOutputStream stream = this.outputStreams.get(i);
            IDataOutputStreamEx os = stream.getStream();
            if (os == null) continue;
            os.flush();
        }
        this.lastStreamFlushTime = TimerCache.timer;
    }

    private void close(Closeable os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public File getCurrentRoot() {
        return this.dumpRoot;
    }

    public long getRecordsWritten() {
        return this.recordsWritten;
    }

    public long getUncompressedSize() {
        long size = 0L;
        int outputStreamsSize = this.outputStreams.size();
        for (int i = 0; i < outputStreamsSize; ++i) {
            ICompressedLocalAndRemoteOutputStream stream = this.outputStreams.get(i);
            size += stream.getUncompressedSize();
        }
        return size;
    }

    public long getCompressedSize() {
        long size = 0L;
        int outputStreamsSize = this.outputStreams.size();
        for (int i = 0; i < outputStreamsSize; ++i) {
            ICompressedLocalAndRemoteOutputStream stream = this.outputStreams.get(i);
            size += stream.getCompressedSize();
        }
        return size;
    }

    public long getDumpTime() {
        return this.dumpTime;
    }

    public long getDumperStartTime() {
        return this.dumperStartTime;
    }

    public long getArchiveSize() {
        if (this.dumpFileManager == null) {
            return 0L;
        }
        return this.dumpFileManager.getCurrentSize();
    }

    public void forceRescanDumpDir() {
        if (this.dumpFileManager == null) {
            return;
        }
        this.dumpFileManager.rescan();
    }

    public DumperCallsExporter getDumperCallsExporter() {
        return this.dumperCallsExporter;
    }

    private class CallsCompressedLocalAndRemoteOutputStream
    extends CompressedLocalAndRemoteOutputStream {
        public CallsCompressedLocalAndRemoteOutputStream(String name, int rotateThreshold, int version) {
            super(name, rotateThreshold, version, new CallsState());
        }

        @Override
        public void fileRotated() throws IOException {
            CallsState callsState = (CallsState)this.getState();
            callsState.threadIdsCounter = 0;
            callsState.threadIdsCache.clear();
            long now = TimerCache.now;
            callsState.callsTimer = (int)(now - TimerCache.startTime);
            this.getStream().writeLong(now);
        }
    }
}

