/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.agent;

import java.lang.reflect.Field;
import org.qubership.profiler.agent.ESCLogger;
import org.qubership.profiler.agent.LocalState;
import org.qubership.profiler.agent.Profiler;

public class IOCounters {
    private static final ESCLogger logger = ESCLogger.getLogger(IOCounters.class);
    private static boolean inputSocketUnavailable;
    private static boolean outputSocketUnavailable;
    private static Field getOutputSocket;
    private static Field getInputSocket;

    public static void fileRead(LocalState state, int size) {
        if (size > 0) {
            state.fileRead += (long)size;
        }
    }

    public static void fileWritten(LocalState state, byte[] b) {
        if (b != null) {
            state.fileWritten += (long)b.length;
        }
    }

    public static void fileWritten(LocalState state, int size) {
        if (size > 0) {
            state.fileWritten += (long)size;
        }
    }

    public static void netRead(LocalState state, int size) {
        IOCounters.netRead(state, (long)size);
    }

    public static void netRead(LocalState state, long size) {
        if (size > 0L) {
            state.netRead += size;
        }
    }

    public static void netWritten(LocalState state, int size) {
        IOCounters.netWritten(state, (long)size);
    }

    public static void netWritten(LocalState state, long size) {
        if (size > 0L) {
            state.netWritten += size;
        }
    }

    public static void dumpInputSocket(Object os) {
        Field s;
        if (inputSocketUnavailable) {
            return;
        }
        if (getInputSocket == null && (s = (getInputSocket = IOCounters.getSocketImpl(os))) == null) {
            inputSocketUnavailable = true;
            return;
        }
        try {
            Object impl = getInputSocket.get(os);
            Profiler.event((Object)impl.toString(), "socket");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void dumpOutputSocket(Object os) {
        Field s;
        if (outputSocketUnavailable) {
            return;
        }
        if (getOutputSocket == null && (s = (getOutputSocket = IOCounters.getSocketImpl(os))) == null) {
            outputSocketUnavailable = true;
            return;
        }
        try {
            Object impl = getOutputSocket.get(os);
            Profiler.event((Object)impl.toString(), "socket");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void dumpSocket(Object socket) {
        try {
            if (socket != null) {
                Profiler.event((Object)socket.toString(), "socket");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Field getSocketImpl(Object stream) {
        Field impl;
        try {
            impl = stream.getClass().getDeclaredField("impl");
            try {
                impl.setAccessible(true);
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable e) {
            logger.severe("", e);
            return null;
        }
        return impl;
    }
}

