/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.analyzer;

import org.qubership.profiler.dom.ProfiledTree;
import org.qubership.profiler.dom.ProfiledTreeStreamVisitor;
import org.qubership.profiler.io.exceptions.ErrorSupervisor;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;

public class MergeTrees
extends ProfiledTreeStreamVisitor {
    public static final Logger log = LoggerFactory.getLogger(MergeTrees.class);
    private ProfiledTree tree;

    public MergeTrees(ProfiledTreeStreamVisitor tv) {
        this(1, tv);
    }

    protected MergeTrees(int api, ProfiledTreeStreamVisitor tv) {
        super(api, tv);
    }

    @Override
    public void visitTree(ProfiledTree tree) {
        if (this.tree == null) {
            this.tree = tree;
        } else {
            this.tree.merge(tree);
        }
    }

    @Override
    public void visitEnd() {
        if (this.tree != null) {
            super.visitTree(this.tree);
        } else {
            ErrorSupervisor.getInstance().warn("MergeTrees finishes with no actual tree. Looks like call to #visitTree was missing", null);
        }
        super.visitEnd();
    }
}

