/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.audit;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;
import org.qubership.profiler.shaded.org.slf4j.MDC;

public class UsernameFilter
implements Filter {
    public static final String PROFILER_REMOTE_USERNAME = "remote.username";
    protected final Logger log = LoggerFactory.getLogger(UsernameFilter.class);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            MDC.put("req.remoteAddr", servletRequest.getRemoteAddr());
            if (servletRequest instanceof HttpServletRequest) {
                HttpServletRequest req = (HttpServletRequest)servletRequest;
                HttpSession session = req.getSession();
                String remoteUser = req.getRemoteUser();
                if (remoteUser == null && session != null) {
                    remoteUser = (String)session.getAttribute(PROFILER_REMOTE_USERNAME);
                }
                MDC.put("req.remoteUser", remoteUser);
                if (session != null && remoteUser != null && session.getAttribute(PROFILER_REMOTE_USERNAME) == null) {
                    session.setAttribute(PROFILER_REMOTE_USERNAME, remoteUser);
                    this.log.info("login");
                }
                this.log.trace("page accessed {}?{}", (Object)req.getRequestURI(), (Object)req.getQueryString());
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            MDC.remove("req.remoteUser");
            MDC.remove("req.remoteAddr");
        }
    }

    @Override
    public void destroy() {
    }
}

