/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.cli;

import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.qubership.profiler.chart.UnaryFunction;
import org.qubership.profiler.cli.ListServers;
import org.qubership.profiler.dump.DataInputStreamEx;
import org.qubership.profiler.dump.DumpRootResolver;
import org.qubership.profiler.io.DurationParser;
import org.qubership.profiler.sax.readers.ProfilerTraceReader;
import org.qubership.profiler.sax.readers.ProfilerTraceReaderFile;
import org.qubership.profiler.sax.values.ClobValue;
import org.qubership.profiler.servlet.SpringBootInitializer;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.inf.Namespace;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;
import org.qubership.profiler.util.IOHelper;
import org.qubership.profiler.utils.CommonUtils;

public class ExportDump
extends ListServers {
    public static final Logger log = LoggerFactory.getLogger(ExportDump.class);
    public static final String DEFAULT_FILE_NAME = "esc_startdate_enddate.zip";
    static final NumberFormat fileIndexFormat = NumberFormat.getIntegerInstance();
    private long startDate;
    private long endDate;
    private String endPath;
    private boolean dryRun;
    private boolean skipDetails;
    private String fileName;
    private List<String> selectedServers;
    private String currentServer;
    private ZipOutputStream zos;
    int totalFiles;
    long totalBytes;
    private final byte[] tmp = new byte[65536];
    private static final Comparator<Long> LONG_COMPARATOR;
    protected static final FileFilter YEAR_DIRECTORY_FILTER;
    protected static final FileFilter NUMBER_DIRECTORY_FILTER;
    private static final UnaryFunction<File, Long> CALLS_START_TIMESTAMP;
    private static final UnaryFunction<File, Long> TRACE_START_TIMESTAMP;

    private static boolean containsOnlyDigits(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isDigit(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int accept(Namespace args) {
        this.setupDumpRoot(args);
        SpringBootInitializer.init();
        TimeZone tz = TimeZone.getTimeZone(args.getString("time_zone"));
        String endDateStr = args.getString("end_date");
        String startDateStr = args.getString("start_date");
        this.endDate = DurationParser.parseTimeInstant(endDateStr, Long.MAX_VALUE, Long.MAX_VALUE, tz);
        this.startDate = DurationParser.parseTimeInstant(startDateStr, Long.MAX_VALUE, this.endDate, tz);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
        sdf.setTimeZone(tz);
        log.info("Exporting the data from {} to {}", (Object)sdf.format(new Date(this.startDate)), (Object)sdf.format(new Date(this.endDate)));
        long now = System.currentTimeMillis();
        if (this.startDate > now) {
            log.error("--start-date and --end-date are in the future. Please clarify the arguments and retry.");
            return -1;
        }
        this.fileName = args.getString("output_file");
        if (DEFAULT_FILE_NAME.equals(this.fileName)) {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmm");
            this.fileName = "esc_" + fmt.format(new Date(this.startDate)) + '_' + fmt.format(new Date(this.endDate)) + ".zip";
        }
        this.skipDetails = args.getBoolean("skip_details");
        if (this.skipDetails) {
            log.info("Will skip export of trace, sql, xml folders");
        }
        this.dryRun = args.getBoolean("dry_run");
        if (this.dryRun) {
            log.info("Running in dry-run mode. No writes will be performed.");
        }
        File file = new File(this.fileName);
        log.info("Will export results to {}", (Object)file.getAbsolutePath());
        this.selectedServers = args.getList("server");
        try {
            return this.runExport();
        }
        catch (IOException e) {
            log.error("Error while exporting data", e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runExport() throws IOException {
        OutputStream os;
        SimpleDateFormat sdf = new SimpleDateFormat("'" + File.separatorChar + "'yyyy'" + File.separatorChar + "'MM'" + File.separatorChar + "'dd");
        this.endPath = this.endDate == Long.MAX_VALUE ? null : sdf.format(this.endDate) + File.separatorChar + this.endDate;
        File dumpRoot = this.getDumpRoot();
        if (dumpRoot == null) {
            log.warn("No dump path found - {}. Please check path to ESC dump (--dump-root)", (Object)DumpRootResolver.dumpRoot);
            return -2;
        }
        try {
            os = this.dryRun ? new OutputStream(){

                @Override
                public void write(int b) {
                }
            } : new FileOutputStream(this.fileName);
        }
        catch (FileNotFoundException e) {
            log.error("Unable to open output file " + this.fileName, e);
            throw e;
        }
        this.zos = new ZipOutputStream(os);
        this.zos.setLevel(0);
        try {
            log.info("Exporting data from {}", (Object)dumpRoot.getAbsolutePath());
            File[] servers = dumpRoot.listFiles(DIRECTORY_FILTER);
            if (servers == null || servers.length == 0) {
                log.warn("No data found in {}. Ensure you set the right --dump-root.", (Object)dumpRoot.getAbsolutePath());
                int n = -2;
                return n;
            }
            for (File server : servers) {
                this.currentServer = server.getName();
                if (this.selectedServers != null && !this.selectedServers.contains(this.currentServer)) {
                    log.debug("Skipping server {} since it does not match --server arguments", (Object)this.currentServer);
                    continue;
                }
                log.debug("Exporting data for server {}", (Object)this.currentServer);
                this.findInFolder(server, "", 0, Long.MAX_VALUE);
            }
        }
        finally {
            IOHelper.close(this.zos);
        }
        if (this.dryRun) {
            log.info("Dry-run export finished successfully. The estimated export size is {} ({} MiB)", (Object)this.totalBytes, (Object)(this.totalBytes / 1024L / 1024L));
        } else {
            File outFile = new File(this.fileName);
            long zipSize = outFile.length();
            log.info("Successfully exported dump to {}. Total export size is {} bytes ({} MiB)", outFile.getAbsolutePath(), zipSize, zipSize / 1024L / 1024L);
        }
        return 0;
    }

    private void findInFolder(File root, String currentPath, int level, long dateUpperBound) throws IOException {
        if (level != 0 && this.endPath != null && currentPath.compareTo(this.endPath) > 0) {
            log.trace("Skipping path {}{} since it does not match the required time-frame", (Object)this.currentServer, (Object)currentPath);
            return;
        }
        if (level == 4) {
            log.info("Processing {}", (Object)root);
            long bytesBefore = this.totalBytes;
            if (this.processCalls(currentPath, root, "calls", CALLS_START_TIMESTAMP, dateUpperBound).isEmpty()) {
                log.debug("Ignoring folder {} since no data in calls sub-folder for the required time-frame is found", (Object)root);
                return;
            }
            this.appendFolder(currentPath, root, "dictionary");
            this.appendFolder(currentPath, root, "params");
            this.appendFolder(currentPath, root, "suspend");
            if (this.skipDetails) {
                log.debug("Skipping exporting of trace, sql, and xml folders since --skip-details is used");
            } else {
                List<File> addedTraceFiles = this.processCalls(currentPath, root, "trace", TRACE_START_TIMESTAMP, dateUpperBound);
                this.processXmlFiles(currentPath, root, addedTraceFiles);
                this.appendFolder(currentPath, root, "sql");
            }
            if (this.totalBytes != bytesBefore) {
                log.info("Added {} bytes ({} MiB total)", (Object)(this.totalBytes - bytesBefore), (Object)(this.totalBytes / 1024L / 1024L));
            }
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Processing {}, level={}", (Object)root.getAbsolutePath(), (Object)level);
        }
        if (root.isDirectory()) {
            Object[] files = root.listFiles(level == 0 ? YEAR_DIRECTORY_FILTER : NUMBER_DIRECTORY_FILTER);
            if (files == null || files.length == 0) {
                return;
            }
            Arrays.sort(files);
            for (int i = 0; i < files.length; ++i) {
                File firstDir;
                Object f = files[i];
                String fileName = ((File)f).getName();
                String nextPath = currentPath + File.separatorChar + fileName;
                long upperBound = level == 3 && i + 1 < files.length ? Long.parseLong(((File)files[i + 1]).getName()) : ((firstDir = this.findFirstDir((File)f, level + 1)) == null ? Long.MAX_VALUE : Long.parseLong(firstDir.getName()));
                this.findInFolder((File)f, nextPath, level + 1, upperBound);
            }
        }
    }

    private void processXmlFiles(String folderInZip, File root, List<File> traceFilese) throws IOException {
        File folder = new File(root, "xml");
        if (!folder.exists()) {
            return;
        }
        folderInZip = folderInZip + File.separatorChar + "xml";
        int[] indexes = this.readFirstAndLastClobFileIdsFromTraceFiles(traceFilese);
        if (indexes.length != 2) {
            return;
        }
        Arrays.sort(indexes);
        for (int i = indexes[0]; i <= indexes[1]; ++i) {
            File file = new File(folder, fileIndexFormat.format(i) + ".gz");
            this.appendFile(folderInZip, file);
        }
    }

    private int[] readFirstAndLastClobFileIdsFromTraceFiles(List<File> traceFiles) {
        Set<ClobValue> clobs;
        if (traceFiles == null || traceFiles.isEmpty()) {
            return new int[0];
        }
        if (traceFiles.size() == 1) {
            clobs = ProfilerTraceReaderFile.readClobIdsOnly(traceFiles.get(0), ProfilerTraceReader.ClobReadMode.FIRST_AND_LAST, ProfilerTraceReader.ClobReadTypes.XML_ONLY);
        } else {
            File firstFile = traceFiles.get(0);
            File lastFile = traceFiles.get(traceFiles.size() - 1);
            clobs = ProfilerTraceReaderFile.readClobIdsOnly(firstFile, ProfilerTraceReader.ClobReadMode.FIRST_ONLY, ProfilerTraceReader.ClobReadTypes.XML_ONLY);
            clobs.addAll(ProfilerTraceReaderFile.readClobIdsOnly(lastFile, ProfilerTraceReader.ClobReadMode.LAST_ONLY, ProfilerTraceReader.ClobReadTypes.XML_ONLY));
        }
        int[] indexes = this.getClobFileIndexes(clobs);
        if (indexes.length == 1) {
            indexes = new int[]{indexes[0], indexes[0]};
        }
        return indexes;
    }

    private int[] getClobFileIndexes(Set<ClobValue> clobs) {
        if (clobs == null) {
            return new int[0];
        }
        int[] indexes = new int[clobs.size()];
        int i = 0;
        for (ClobValue clob : clobs) {
            indexes[i] = clob.fileIndex;
            ++i;
        }
        return indexes;
    }

    private File findFirstDir(File root, int level) {
        if (level == 0) {
            return null;
        }
        File[] files = root.getParentFile().listFiles(level - 1 == 0 ? YEAR_DIRECTORY_FILTER : NUMBER_DIRECTORY_FILTER);
        if (files == null || files.length == 0) {
            return null;
        }
        String rootName = root.getName();
        File next = null;
        String nextName = null;
        for (File file : files) {
            String name = file.getName();
            if (name.compareTo(rootName) <= 0 || nextName != null && nextName.compareTo(name) <= 0) continue;
            next = file;
            nextName = name;
        }
        if (log.isDebugEnabled()) {
            log.debug("Next folder for {} is {}", (Object)root, (Object)next);
        }
        if (next == null) {
            return this.findFirstDir(root.getParentFile(), level - 1);
        }
        return this.findFirstLogDir(next, level);
    }

    private File findFirstLogDir(File root, int level) {
        log.debug("Searching for the first log directory in {}, level {}", (Object)root, (Object)level);
        if (root.isDirectory()) {
            Object[] files = root.listFiles(level == 0 ? YEAR_DIRECTORY_FILTER : NUMBER_DIRECTORY_FILTER);
            if (files == null || files.length == 0) {
                log.debug("Folder {} has no files", (Object)root);
                return null;
            }
            if (level == 3) {
                File min = Collections.min(Arrays.asList(files));
                log.debug("Minimal file in root {} is {}", (Object)root, (Object)min);
                return min;
            }
            Arrays.sort(files);
            for (Object f : files) {
                File res = this.findFirstLogDir((File)f, level + 1);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    private void appendFolder(String folderInZip, File root, String folderName) throws IOException {
        folderInZip = folderInZip + File.separatorChar + folderName;
        File folder = new File(root, folderName);
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            this.appendFile(folderInZip, file);
        }
    }

    private List<File> processCalls(String folderInZip, File root, String folderName, UnaryFunction<File, Long> keySelector, long dateUpperBound) throws IOException {
        int to;
        folderInZip = folderInZip + File.separatorChar + folderName;
        File folder = new File(root, folderName);
        if (!folder.exists()) {
            return Collections.emptyList();
        }
        Object[] files = folder.listFiles();
        if (files == null || files.length == 0) {
            return Collections.emptyList();
        }
        Arrays.sort(files);
        if (dateUpperBound < this.startDate) {
            log.debug("Ignoring folder {} since the estimate of upper bound of stored data is {}, and requested startDate is {}", folder, new Date(dateUpperBound), new Date(this.startDate));
            return Collections.emptyList();
        }
        int from = CommonUtils.upperBound(files, this.startDate, 0, files.length - 1, keySelector, LONG_COMPARATOR);
        if (from == files.length) {
            --from;
        }
        if ((to = CommonUtils.upperBound(files, this.endDate, 0, files.length - 1, keySelector, LONG_COMPARATOR)) == files.length) {
            --to;
        }
        if ((from = Math.max(from, 0)) > (to = Math.max(to, 0))) {
            log.debug("Ignoring folder {} since files look out of range of specified dates", (Object)folder.getAbsolutePath());
            return Collections.emptyList();
        }
        ArrayList<File> addedFiles = new ArrayList<File>();
        for (int i = from; i <= to; ++i) {
            Object file = files[i];
            this.appendFile(folderInZip, (File)file);
            addedFiles.add((File)file);
        }
        return addedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendFile(String folder, File file) throws IOException {
        FileInputStream is;
        String zipFileName = "execution-statistics-collector" + File.separatorChar + "dump" + File.separatorChar + this.currentServer + folder + File.separatorChar + file.getName();
        if (log.isTraceEnabled()) {
            log.trace("Adding file {} as {}", (Object)file, (Object)zipFileName);
        }
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            log.warn("Unable to open file " + file.getAbsolutePath(), e);
            return;
        }
        ++this.totalFiles;
        this.totalBytes += file.length();
        if (this.dryRun) {
            log.trace("Avoiding file copy since running in dry-run mode {}", (Object)file);
            ((InputStream)is).close();
            return;
        }
        ZipEntry ze = new ZipEntry(zipFileName);
        ze.setTime(file.lastModified());
        ze.setSize(file.length());
        this.zos.putNextEntry(ze);
        try {
            int read;
            while ((read = ((InputStream)is).read(this.tmp)) > 0) {
                this.zos.write(this.tmp, 0, read);
            }
        }
        finally {
            ((InputStream)is).close();
        }
        this.zos.closeEntry();
    }

    public static <T, K> int lowerBound(T[] a, K key, int imin, int imax, UnaryFunction<T, K> keySelector, Comparator<K> comparator) {
        while (imin < imax) {
            int imid = imin + imax >>> 1;
            assert (imid < imax) : "search interval should be reduced min=" + imin + ", mid=" + imid + ", max=" + imax;
            if (comparator.compare(keySelector.evaluate(a[imid]), key) < 0) {
                imin = imid + 1;
                continue;
            }
            imax = imid;
        }
        if (imax != imin) {
            return -1;
        }
        int cmp = comparator.compare(keySelector.evaluate(a[imin]), key);
        if (cmp == 0) {
            return imin;
        }
        if (cmp < 0) {
            return imin + 1;
        }
        if (imin == 0) {
            return -1;
        }
        return imin;
    }

    static {
        fileIndexFormat.setGroupingUsed(false);
        fileIndexFormat.setMinimumIntegerDigits(6);
        LONG_COMPARATOR = new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                return o1.compareTo(o2);
            }
        };
        YEAR_DIRECTORY_FILTER = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().length() == 4 && ExportDump.containsOnlyDigits(pathname.getName());
            }
        };
        NUMBER_DIRECTORY_FILTER = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && ExportDump.containsOnlyDigits(pathname.getName());
            }
        };
        CALLS_START_TIMESTAMP = new UnaryFunction<File, Long>(){

            @Override
            public Long evaluate(File file) {
                try {
                    DataInputStreamEx calls = DataInputStreamEx.openDataInputStream(file);
                    if (calls == null) {
                        return System.currentTimeMillis();
                    }
                    long time = calls.readLong();
                    if ((int)(time >>> 32) == -66052) {
                        time = calls.readLong();
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("Timestamp of {} is {} ({})", file.getAbsolutePath(), new Date(time), time);
                    }
                    return time;
                }
                catch (EOFException e) {
                    return System.currentTimeMillis();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        TRACE_START_TIMESTAMP = new UnaryFunction<File, Long>(){

            @Override
            public Long evaluate(File file) {
                DataInputStreamEx trace = null;
                try {
                    trace = DataInputStreamEx.openDataInputStream(file);
                    if (trace == null) {
                        Long l = System.currentTimeMillis();
                        return l;
                    }
                    trace.readLong();
                    trace.readLong();
                    long realTime = trace.readLong();
                    if (log.isTraceEnabled()) {
                        log.trace("Timestamp of {} is {} ({})", file.getAbsolutePath(), new Date(realTime), realTime);
                    }
                    Long l = realTime;
                    return l;
                }
                catch (EOFException e) {
                    Long l = System.currentTimeMillis();
                    return l;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    IOHelper.close(trace);
                }
            }
        };
    }
}

