/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.cloud.transport;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class ESCStopWatch {
    long total = 0L;
    long prevStart = -1L;
    Collection<ESCStopWatch> watchesToStopWhenStart = Collections.emptyList();
    Collection<ESCStopWatch> watchesToStartWhenStop = Collections.emptyList();

    private Collection<ESCStopWatch> emptyIfNull(ESCStopWatch ... watches) {
        if (watches == null || watches.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(watches);
    }

    public void stopWhenStart(ESCStopWatch ... watches) {
        this.watchesToStopWhenStart = this.emptyIfNull(watches);
    }

    public void startWhenStop(ESCStopWatch ... watches) {
        this.watchesToStartWhenStop = this.emptyIfNull(watches);
    }

    public void start() {
        if (this.prevStart < 0L) {
            for (ESCStopWatch w : this.watchesToStopWhenStart) {
                w.stop();
            }
            this.prevStart = this.nowNanos();
        }
    }

    public void stop() {
        if (this.prevStart < 0L) {
            return;
        }
        this.total += this.nowNanos() - this.prevStart;
        this.prevStart = -1L;
        for (ESCStopWatch w : this.watchesToStartWhenStop) {
            w.start();
        }
    }

    protected long nowNanos() {
        return System.nanoTime();
    }

    public long getAndReset() {
        this.stop();
        long result = this.total;
        this.total = 0L;
        this.prevStart = -1L;
        return result;
    }

    public static ESCStopWatch getWatch(ThreadLocal<ESCStopWatch> tl) {
        ESCStopWatch result = tl.get();
        if (result == null) {
            result = new ESCStopWatch();
            tl.set(result);
        }
        return result;
    }
}

