/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.cloud.transport;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.qubership.profiler.cloud.transport.ProfilerProtocolException;

public class PhraseOutputStream
extends ByteArrayOutputStream {
    private BufferedOutputStream bufferedOutputStream;
    private int length;

    public PhraseOutputStream(OutputStream out, int size, int outputBufferSize) {
        super(size);
        this.bufferedOutputStream = new BufferedOutputStream(out, outputBufferSize);
    }

    @Override
    public synchronized void write(int b) {
        this.ensureCapacity(1);
        super.write(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        this.ensureCapacity(len);
        super.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.ensureCapacity(b.length);
        super.write(b);
    }

    private void ensureCapacity(int numToWrite) {
        if (numToWrite > this.buf.length) {
            throw new ProfilerProtocolException("Can not write a phrase: buffer of " + this.buf.length + " bytes exceeded. requested size is " + numToWrite);
        }
        if (this.size() + numToWrite >= this.buf.length) {
            try {
                this.writeDataIntoOutputStream();
            }
            catch (IOException e) {
                throw new ProfilerProtocolException(e);
            }
        }
        if (this.size() + numToWrite >= this.buf.length) {
            throw new ProfilerProtocolException("Can not write a phrase: buffer of " + this.buf.length + " bytes exceeded. requested size is " + numToWrite + ". uncommited size is " + this.size());
        }
    }

    public void writePhrase() throws IOException {
        this.length = super.size();
        if (super.size() < this.buf.length - 200) {
            return;
        }
        this.writeDataIntoOutputStream();
    }

    @Override
    public synchronized void flush() throws IOException {
        this.writeDataIntoOutputStream();
        this.bufferedOutputStream.flush();
    }

    private void writeDataIntoOutputStream() throws IOException {
        if (this.length == 0) {
            return;
        }
        new DataOutputStream(this.bufferedOutputStream).writeInt(this.length);
        if (this.length == super.size()) {
            this.bufferedOutputStream.write(this.buf, 0, this.count);
            super.reset();
        } else {
            int count = this.size();
            this.bufferedOutputStream.write(this.buf, 0, this.length);
            super.reset();
            this.write(this.buf, this.length, count - this.length);
        }
        this.length = 0;
    }

    @Override
    public void close() throws IOException {
        try (BufferedOutputStream ostream = this.bufferedOutputStream;){
            this.flush();
        }
    }

    public int getPhraseLength() {
        return this.length;
    }
}

