/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.formatters.title;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.qubership.profiler.agent.ParameterInfo;
import org.qubership.profiler.formatters.title.AbstractTitleFormatter;
import org.qubership.profiler.formatters.title.Function;
import org.qubership.profiler.formatters.title.ProfilerTitle;
import org.qubership.profiler.formatters.title.ProfilerTitleBuilder;
import org.qubership.profiler.formatters.title.RegexpCommonCall;
import org.qubership.profiler.formatters.title.TitleCommonTools;
import org.qubership.profiler.formatters.title.UrlPatternReplacer;
import org.qubership.profiler.shaded.org.apache.commons.lang.StringUtils;

public class HttpTitleFormatter
extends AbstractTitleFormatter {
    public static final String DISABLE_DEFAULT_URL_REPLACE_PATTERNS = "disableDefaultUrlReplacePatterns";
    public static final String MIN_DIGITS_IN_ID = "minDigitsInId";
    public static final String URL_PATTERN_REPLACER = "urlPatternReplacer";
    private static final int DEFAULT_MIN_DIGITS_IN_ID = 4;
    private Set<String> SKIP_PARAMS = Collections.singleton("jmeter.step");
    private Pattern uiComponentPatternRegEx1 = Pattern.compile("/ \\S+ (?=/)");
    private Pattern uiComponentPatternRegEx2 = Pattern.compile("localValue=((?:\\S|(?!\\s(?:/|\\S+=))\\s)+)");

    @Override
    public ProfilerTitle formatTitle(String classMethod, Map<String, Integer> tagToIdMap, Object params, List<ParameterInfo> defaultListParams) {
        Collection<String> uiComponents;
        ProfilerTitleBuilder title = new ProfilerTitleBuilder();
        String jmeterStep = TitleCommonTools.getParameter(tagToIdMap, params, "jmeter.step");
        if (!jmeterStep.isEmpty()) {
            title.append("JMeter: ").appendHtml("<b>").append(jmeterStep).appendHtml("</b>").append(", ");
        }
        if (!(uiComponents = TitleCommonTools.getParameterValues(tagToIdMap, params, "ui.component")).isEmpty()) {
            if (uiComponents.size() > 1) {
                title.append(uiComponents.size()).append(" CBTUI actions ");
                for (String s : uiComponents) {
                    title.append(this.formatUIComponent(s));
                }
            } else {
                title.append(this.formatUIComponent(uiComponents.iterator().next()));
            }
        } else {
            Collection<String> webUrls = TitleCommonTools.getParameterValues(tagToIdMap, params, "web.url");
            Collection<String> webQueries = TitleCommonTools.getParameterValues(tagToIdMap, params, "web.query");
            if (webUrls.size() == 1 && webQueries.size() <= 1) {
                String webMethod = TitleCommonTools.getParameter(tagToIdMap, params, "web.method");
                if (!webMethod.isEmpty()) {
                    title.append(webMethod).append(Character.valueOf(' '));
                }
                if (webQueries.size() == 1) {
                    title.append(this.getURLPath(webUrls.iterator().next())).append(Character.valueOf('?')).append(webQueries.iterator().next());
                } else {
                    title.append(this.getURLPath(webUrls.iterator().next()));
                }
            } else if (!webUrls.isEmpty()) {
                title.append(webUrls.size()).append(" pages: ");
                for (String s : webUrls) {
                    title.append(this.getURLPath(s));
                    title.append(", ");
                }
                title.deleteLastChars(2);
                if (!webQueries.isEmpty()) {
                    title.append(", ").append(webQueries.size()).append(" query strings: ").append(StringUtils.join(webQueries, ", "));
                }
            }
        }
        TitleCommonTools.addParameter(title, tagToIdMap, params, ", client: ", "web.remote.addr", new Function<Collection<String>, String>(){

            @Override
            public String apply(Collection<String> remoteAddresses) {
                return StringUtils.join(new HashSet<String>(remoteAddresses), ", ");
            }
        });
        TitleCommonTools.addGenericParams(title, tagToIdMap, params, defaultListParams, this.SKIP_PARAMS);
        return title;
    }

    @Override
    public ProfilerTitle formatCommonTitle(String classMethod, Map<String, Integer> tagToIdMap, Map<Integer, List<String>> params, Map<String, Object> formatContext) {
        ProfilerTitleBuilder title = new ProfilerTitleBuilder();
        boolean disableDefaultUrlReplacePatterns = (Boolean)formatContext.get(DISABLE_DEFAULT_URL_REPLACE_PATTERNS);
        int minDigitsInId = (Integer)formatContext.get(MIN_DIGITS_IN_ID);
        if (minDigitsInId == 0) {
            minDigitsInId = 4;
        }
        UrlPatternReplacer urlPatternReplacer = (UrlPatternReplacer)formatContext.get(URL_PATTERN_REPLACER);
        Collection<String> webUrlList = TitleCommonTools.getParameterValues(tagToIdMap, params, "web.url");
        if (webUrlList.isEmpty()) {
            title.append(classMethod).setDefault(true);
            return title;
        }
        if (webUrlList.size() == 1) {
            String webUrlStr = webUrlList.iterator().next();
            Collection<String> webMethodList = TitleCommonTools.getParameterValues(tagToIdMap, params, "web.method");
            String webMethodStr = webMethodList.isEmpty() ? "" : webMethodList.iterator().next();
            title.append("HTTP ").append(webMethodStr).append(" ").append(this.parseCommonURL(webUrlStr, disableDefaultUrlReplacePatterns, minDigitsInId, urlPatternReplacer));
        } else {
            title.append("HTTP ").append(webUrlList.size()).append(" pages: ");
            for (String webUrlStr : webUrlList) {
                title.append(this.parseCommonURL(webUrlStr, disableDefaultUrlReplacePatterns, minDigitsInId, urlPatternReplacer)).append(", ");
            }
            title.deleteLastChars(2);
        }
        return title;
    }

    private String getURLPath(String url) {
        int pathIndex = url.indexOf(47, url.indexOf("://") + 3);
        return pathIndex == -1 ? url : url.substring(pathIndex);
    }

    private String formatUIComponent(String uiComponent) {
        String result = this.uiComponentPatternRegEx1.matcher(uiComponent).replaceAll("");
        result = this.uiComponentPatternRegEx2.matcher(result).replaceAll("$1");
        return result;
    }

    private String parseCommonURL(String webUrlStr, boolean disableDefaultUrlReplacePatterns, int minDigitsInId, UrlPatternReplacer urlPatternReplacer) {
        String commonUrl = RegexpCommonCall.replaceUrl(webUrlStr);
        if (!disableDefaultUrlReplacePatterns) {
            commonUrl = RegexpCommonCall.replaceIds(RegexpCommonCall.replaceSalesOrderDataContext(commonUrl), minDigitsInId);
        }
        commonUrl = urlPatternReplacer.replace(commonUrl);
        return commonUrl;
    }
}

