/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DurationParser {
    static final Pattern TIME_EXPR = Pattern.compile("^-?([0-9\\.]+)(d|day|days|h|ho|hou|hour|hours|m|mi|min|minu|minut|minute|minutes|s|se|sec|seco|secon|second|seconds)?(?:ago)?$");
    static final Pattern DURATION_EXPR = Pattern.compile("-?(\\d+)\\s*(ms|mil|mo|m|s|h|d|w|y)?");

    static long parseTime(String str, long def) {
        if ("now".equals(str)) {
            return System.currentTimeMillis();
        }
        Matcher m = TIME_EXPR.matcher(str);
        if (!m.matches()) {
            return def;
        }
        double value = Double.parseDouble(m.group(1));
        String unit = m.group(2);
        if (unit == null || unit.length() == 0) {
            unit = "h";
        }
        value = unit.startsWith("d") ? (value *= 8.64E7) : (unit.startsWith("m") ? (value *= 60000.0) : (unit.startsWith("s") ? (value *= 1000.0) : (value *= 3600000.0)));
        return (long)((double)System.currentTimeMillis() - value);
    }

    static long[] parseTimerange(String str) {
        long rangeHigh;
        str = str.replaceAll("\\s+", "");
        str = str.toLowerCase();
        String[] rangeBounds = str.split("\\.{2,}");
        long rangeLow = DurationParser.parseTime(rangeBounds[0], System.currentTimeMillis() - 3600000L);
        long l = rangeHigh = rangeBounds.length > 1 ? DurationParser.parseTime(rangeBounds[1], System.currentTimeMillis()) : System.currentTimeMillis();
        if (rangeLow > rangeHigh) {
            long t = rangeLow;
            rangeLow = rangeHigh;
            rangeHigh = t;
        }
        return new long[]{rangeLow, rangeHigh};
    }

    public static long parseDuration(String str, long def) {
        str = str.toLowerCase();
        Matcher m = DURATION_EXPR.matcher(str);
        long value = 0L;
        boolean matched = false;
        while (m.find()) {
            matched = true;
            String unit = m.group(2);
            long qty = Long.parseLong(m.group(1));
            if (unit == null || unit.length() == 0) {
                unit = "d";
            }
            if (unit.startsWith("y")) {
                qty *= 31449600000L;
            } else if (unit.startsWith("mo")) {
                qty *= 2592000000L;
            } else if (unit.startsWith("w")) {
                qty *= 604800000L;
            } else if (unit.startsWith("d")) {
                qty *= 86400000L;
            } else if (unit.startsWith("h")) {
                qty *= 3600000L;
            } else if (!unit.equals("ms") && !unit.startsWith("mil")) {
                if (unit.startsWith("m")) {
                    qty *= 60000L;
                } else if (unit.startsWith("s")) {
                    qty *= 1000L;
                }
            }
            if (m.group(0).charAt(0) == '-') {
                value -= qty;
                continue;
            }
            value += qty;
        }
        if (!matched) {
            return def;
        }
        return value;
    }

    static long[] parseDurationRange(String str) {
        long rangeHigh;
        str = str.replaceAll("\\s+", "");
        str = str.toLowerCase();
        str = str.replaceAll("[<>=]", "");
        String[] rangeBounds = str.split("\\.{2,}");
        long rangeLow = DurationParser.parseDuration(rangeBounds[0], 100L);
        long l = rangeHigh = rangeBounds.length > 1 ? DurationParser.parseDuration(rangeBounds[1], Long.MAX_VALUE) : Long.MAX_VALUE;
        if (rangeLow > rangeHigh) {
            long t = rangeLow;
            rangeLow = rangeHigh;
            rangeHigh = t;
        }
        return new long[]{rangeLow, rangeHigh};
    }

    public static long parseTimeInstant(String str, long def, long max, TimeZone tz) {
        try {
            int i;
            long time = Long.parseLong(str);
            long now = System.currentTimeMillis();
            long maxDate = now + 63072000000L;
            long minDate = now - 220752000000L;
            for (i = 0; i < 3 && Math.abs(now - time) > Math.abs(now - time * 10L); ++i) {
                time *= 10L;
            }
            for (i = 0; i < 3 && Math.abs(now - time) > Math.abs(now - time / 10L); ++i) {
                time /= 10L;
            }
            if (time >= minDate && time <= maxDate) {
                return time;
            }
        }
        catch (NumberFormatException time) {
            // empty catch block
        }
        List<String> formats = Arrays.asList("yyyy-MM-dd HH:mm", "MM-dd HH:mm", "dd HH:mm", "HH:mm");
        for (int i = 0; i < formats.size(); ++i) {
            long time;
            String fmt = formats.get(i);
            SimpleDateFormat sdf = new SimpleDateFormat(fmt);
            sdf.setTimeZone(tz);
            try {
                time = sdf.parse(str).getTime();
            }
            catch (ParseException e) {
                continue;
            }
            Calendar now = Calendar.getInstance();
            now.setTimeZone(tz);
            Calendar cal = Calendar.getInstance();
            cal.setTimeZone(tz);
            cal.setTimeInMillis(time);
            cal.set(13, 0);
            cal.set(14, 0);
            switch (i) {
                case 3: {
                    cal.set(5, now.get(5));
                }
                case 2: {
                    cal.set(2, now.get(2));
                }
                case 1: {
                    cal.set(1, now.get(1));
                }
            }
            time = cal.getTimeInMillis();
            if (time > max) {
                int field = fmt.startsWith("HH") ? 5 : (fmt.startsWith("dd") ? 2 : 1);
                while (time > max) {
                    cal.add(field, -1);
                    time = cal.getTimeInMillis();
                }
            }
            return time;
        }
        if ("now".equalsIgnoreCase(str)) {
            return System.currentTimeMillis();
        }
        long offs = DurationParser.parseDuration(str, Long.MAX_VALUE);
        if (offs != Long.MAX_VALUE) {
            return System.currentTimeMillis() - offs;
        }
        return def;
    }
}

