/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.qubership.profiler.configuration.ParameterInfoDto;
import org.qubership.profiler.dump.DataInputStreamEx;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;
import org.qubership.profiler.util.IOHelper;

public abstract class ParamReader {
    Logger logger = LoggerFactory.getLogger(ParamReader.class);

    public abstract Map<String, ParameterInfoDto> fillParamInfo(Collection<Throwable> var1, String var2);

    public abstract List<String> fillTags(BitSet var1, Collection<Throwable> var2);

    public abstract List<String> fillCallsTags(Collection<Throwable> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBig(File root, Map<Integer, Map<Integer, String>> result, String fileName, Collection<Throwable> exceptions, int paramsTrimSize) {
        if (result.isEmpty()) {
            return;
        }
        String rootName = root.getAbsolutePath() + File.separatorChar + fileName + File.separatorChar;
        for (Map.Entry<Integer, Map<Integer, String>> idx : result.entrySet()) {
            DataInputStreamEx dedupIs = null;
            String exceptionMessage = null;
            try {
                try {
                    dedupIs = DataInputStreamEx.reopenDataInputStream(dedupIs, root, fileName, idx.getKey());
                }
                catch (FileNotFoundException e) {
                    dedupIs = null;
                    exceptionMessage = e.toString();
                    exceptions.add(e);
                }
                catch (IOException e) {
                    exceptions.add(e);
                    exceptionMessage = e.toString() + ", file " + rootName + idx.getKey() + " reached";
                }
                Map<Integer, String> map = idx.getValue();
                Object[] ids = map.keySet().toArray(new Integer[map.size()]);
                Arrays.sort(ids);
                for (Object id : ids) {
                    String value = null;
                    if (dedupIs != null) {
                        try {
                            dedupIs.skipBytes((Integer)id - dedupIs.position());
                            StringWriter sw = new StringWriter();
                            int realLength = dedupIs.readString(sw, paramsTrimSize);
                            value = sw.toString();
                        }
                        catch (EOFException e) {
                            exceptions.add(e);
                            exceptionMessage = "End of file " + rootName + idx.getKey() + " reached";
                        }
                        catch (IOException e) {
                            exceptions.add(e);
                            exceptionMessage = e.toString() + ", file " + rootName + idx.getKey() + " reached";
                        }
                    }
                    if (value == null) {
                        value = exceptionMessage + ", byte offset in file " + id;
                    }
                    map.put((Integer)id, value);
                }
            }
            catch (Throwable throwable) {
                IOHelper.close(dedupIs);
                throw throwable;
            }
            IOHelper.close(dedupIs);
        }
    }

    public Object[] getInflightCalls() {
        return null;
    }
}

