/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.metrics;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.qubership.profiler.agent.HistogramIterationType;
import org.qubership.profiler.agent.MetricType;
import org.qubership.profiler.metrics.AbstractMetric;
import org.qubership.profiler.metrics.AggregationParameter;
import org.qubership.profiler.metrics.MetricUnit;
import org.qubership.profiler.shaded.org.HdrHistogram.HistogramIterationValue;
import org.qubership.profiler.shaded.org.HdrHistogram.SynchronizedHistogram;
import org.qubership.profiler.shaded.org.apache.commons.lang.StringUtils;

public abstract class AbstractHistogramMetric
extends AbstractMetric {
    public static final String BUCKET_SUFFIX = "bucket";
    public static final String SUM_SUFFIX = "sum";
    public static final String COUNT_SUFFIX = "count";
    protected SynchronizedHistogram histogram;
    protected AtomicLong sum = new AtomicLong();
    protected long lowestDiscernibleValue = 1L;
    protected long highestTrackableValue = 10000000L;
    protected int numberOfSignificantValueDigits = 2;
    protected HistogramIterationType histogramIterationType = HistogramIterationType.LOGARITHMIC_BUCKET_VALUES;
    protected int percentileTicksPerHalfDistance = 4;
    protected long valueUnitsInFirstBucket = 100L;
    protected double logBase = 2.0;
    protected long valueUnitsPerBucket = 100L;
    private String sumKey;
    private String countKey;

    public AbstractHistogramMetric(String callType, MetricType type, HashSet<AggregationParameter> aggregationParameters, MetricUnit metricUnit, int outputVersion, String suffix) {
        super(callType, type, aggregationParameters, metricUnit, outputVersion, suffix);
        this.sumKey = this.buildKey(callType, type, aggregationParameters, metricUnit, SUM_SUFFIX);
        this.countKey = this.buildKey(callType, type, aggregationParameters, MetricUnit.TOTAL, COUNT_SUFFIX);
    }

    @Override
    public void resetValue() {
        this.histogram.reset();
        this.sum.set(0L);
    }

    protected void initHistogram() {
        this.histogram = new SynchronizedHistogram(this.lowestDiscernibleValue, this.highestTrackableValue, this.numberOfSignificantValueDigits);
    }

    protected void parseHistogramParameters(Map<String, String> metricParameters) {
        String percentileTicksPerHalfDistanceStr;
        String valueUnitsPerBucketStr;
        String logBaseStr;
        String valueUnitsInFirstBucketStr;
        HistogramIterationType iterationType;
        String numberOfSignificantValueDigitsStr;
        String highestTrackableValueStr;
        String lowestDiscernibleValueStr = metricParameters.get("lowestDiscernibleValue");
        if (!StringUtils.isEmpty(lowestDiscernibleValueStr)) {
            this.lowestDiscernibleValue = Long.parseLong(lowestDiscernibleValueStr);
        }
        if (!StringUtils.isEmpty(highestTrackableValueStr = metricParameters.get("highestTrackableValue"))) {
            this.highestTrackableValue = Long.parseLong(highestTrackableValueStr);
        }
        if (!StringUtils.isEmpty(numberOfSignificantValueDigitsStr = metricParameters.get("numberOfSignificantValueDigits"))) {
            this.numberOfSignificantValueDigits = Integer.parseInt(numberOfSignificantValueDigitsStr);
        }
        if ((iterationType = HistogramIterationType.getByConfigName(metricParameters.get("iterationType"))) != null) {
            this.histogramIterationType = iterationType;
        }
        if (!StringUtils.isEmpty(valueUnitsInFirstBucketStr = metricParameters.get("valueUnitsInFirstBucket"))) {
            this.valueUnitsInFirstBucket = Long.parseLong(valueUnitsInFirstBucketStr);
        }
        if (!StringUtils.isEmpty(logBaseStr = metricParameters.get("logBase"))) {
            this.logBase = Double.parseDouble(logBaseStr);
        }
        if (!StringUtils.isEmpty(valueUnitsPerBucketStr = metricParameters.get("valueUnitsPerBucket"))) {
            this.valueUnitsPerBucket = Long.parseLong(valueUnitsPerBucketStr);
        }
        if (!StringUtils.isEmpty(percentileTicksPerHalfDistanceStr = metricParameters.get("percentileTicksPerHalfDistance"))) {
            this.percentileTicksPerHalfDistance = Integer.parseInt(percentileTicksPerHalfDistanceStr);
        }
    }

    protected void recordValue(long value) {
        if (value > this.highestTrackableValue) {
            value = this.highestTrackableValue;
        }
        this.histogram.recordValue(value);
        this.sum.addAndGet(value);
    }

    private Iterable<HistogramIterationValue> getHistogramIterator() {
        switch (this.histogramIterationType) {
            case PERCENTILES: {
                return this.histogram.percentiles(this.percentileTicksPerHalfDistance);
            }
            case LINEAR_BUCKET_VALUES: {
                return this.histogram.linearBucketValues(this.valueUnitsPerBucket);
            }
            case LOGARITHMIC_BUCKET_VALUES: {
                return this.histogram.logarithmicBucketValues(this.valueUnitsInFirstBucket, this.logBase);
            }
            case ALL_VALUES: {
                return this.histogram.allValues();
            }
            case RECORDED_VALUES: {
                return this.histogram.recordedValues();
            }
        }
        return null;
    }

    @Override
    public void print(StringBuilder out) {
        for (HistogramIterationValue histogramIterationValue : this.getHistogramIterator()) {
            if (histogramIterationValue.getTotalCountToThisValue() == 0L) continue;
            out.append(this.key);
            if (out.charAt(out.length() - 1) != '{') {
                out.append(", ");
            }
            out.append("le=\"").append(histogramIterationValue.getValueIteratedTo()).append("\"} ").append(histogramIterationValue.getTotalCountToThisValue()).append("\n");
        }
        out.append(this.key);
        if (out.charAt(out.length() - 1) != '{') {
            out.append(", ");
        }
        out.append("le=\"+Inf\"} ").append(this.histogram.getTotalCount()).append("\n");
        out.append(this.sumKey).append("} ").append(this.sum.get()).append("\n");
        out.append(this.countKey).append("} ").append(this.histogram.getTotalCount()).append("\n");
    }
}

